/*
 * Decompiled with CFR 0.152.
 */
package net.alternativewill.kingdomsanddynasties2.item.custom;

import java.util.List;
import java.util.function.Consumer;
import net.alternativewill.kingdomsanddynasties2.item.client.RendererInstances;
import net.alternativewill.kingdomsanddynasties2.item.client.TenguMaskRenderer;
import net.alternativewill.kingdomsanddynasties2.util.ColorCombiner;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class TenguMaskItem
extends DyeableArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public static final int STANDARD_CRAFTING_TABLE_COLOR = 0xFFFFFF;
    public static final int STANDARD_PRIMARY_COLOR = 0xFFFFFF;
    public static final int STANDARD_SECONDARY_COLOR = 0xFFFFFF;
    public static final int STANDARD_GOLD_COLOR = 0xFFFFFF;
    public static final int STANDARD_SILVER_COLOR = 0xFFFFFF;
    public static final int STANDARD_COLOR = 0xFFFFFF;
    public static final String PRIMARY_PART = "primary";
    public static final String SECONDARY_PART = "secondary";
    public static final String GOLD_PART = "gold";
    public static final String SILVER_PART = "silver";
    public static final String CRAFTING_TABLE_PART = "color";

    public TenguMaskItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private TenguMaskRenderer renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new TenguMaskRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return RendererInstances.TENGU_MASK_RENDERER;
            }
        });
    }

    private PlayState predicate(AnimationState animationState) {
        animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void m_41115_(@NotNull ItemStack stack, int color) {
        CompoundTag displayTag = stack.m_41698_("display");
        displayTag.m_128405_(CRAFTING_TABLE_PART, color);
    }

    public void setPrimaryColor(@NotNull ItemStack stack, int color) {
        this.setColorTag(stack, PRIMARY_PART, color, 0xFFFFFF);
    }

    public void setSecondaryColor(@NotNull ItemStack stack, int color) {
        this.setColorTag(stack, SECONDARY_PART, color, 0xFFFFFF);
    }

    public void setGoldColor(@NotNull ItemStack stack, int color) {
        this.setColorTag(stack, GOLD_PART, color, 0xFFFFFF);
    }

    public void setSilverColor(@NotNull ItemStack stack, int color) {
        this.setColorTag(stack, SILVER_PART, color, 0xFFFFFF);
    }

    public int getPrimaryColor(@NotNull ItemStack stack) {
        return this.getColorTag(stack, PRIMARY_PART, 0xFFFFFF);
    }

    public int getSecondaryColor(@NotNull ItemStack stack) {
        return this.getColorTag(stack, SECONDARY_PART, 0xFFFFFF);
    }

    public int getGoldColor(@NotNull ItemStack stack) {
        return this.getColorTag(stack, GOLD_PART, 0xFFFFFF);
    }

    public int getSilverColor(@NotNull ItemStack stack) {
        return this.getColorTag(stack, SILVER_PART, 0xFFFFFF);
    }

    public int m_41121_(@NotNull ItemStack stack) {
        return this.getColorTag(stack, CRAFTING_TABLE_PART, 0xFFFFFF);
    }

    public int getCraftingTableColor(ItemStack stack) {
        return this.m_41121_(stack);
    }

    public void wipeColors(@NotNull ItemStack stack, String tag, int color, Player player) {
        CompoundTag displayTag = stack.m_41698_("display");
        if (displayTag.m_128441_(tag)) {
            displayTag.m_128473_(tag);
            stack.m_41698_("display").m_128405_(tag, color);
            player.m_150109_().f_35975_.set(player.m_150109_().f_35975_.indexOf((Object)stack), (Object)stack);
            player.m_150109_().m_6596_();
        } else {
            System.out.println("Tag " + tag + " not found in displayTag from stack: " + stack);
        }
    }

    private void setColorTag(@NotNull ItemStack stack, String tag, int color, int defaultColor) {
        int currentColor;
        CompoundTag displayTag = stack.m_41698_("display");
        int n = currentColor = displayTag.m_128451_(tag) == 0 ? defaultColor : displayTag.m_128451_(tag);
        if (currentColor != color) {
            int blendedColor = ColorCombiner.combineColors(List.of(Integer.valueOf(currentColor), Integer.valueOf(color)));
            displayTag.m_128405_(tag, blendedColor);
        }
    }

    private void undoColorTag(@NotNull ItemStack stack, String tag, int defaultColor) {
        CompoundTag displayTag = stack.m_41698_("display");
        if (displayTag.m_128441_("previous_" + tag)) {
            int previousColor = displayTag.m_128451_("previous_" + tag);
            displayTag.m_128405_(tag, previousColor);
            displayTag.m_128473_("previous_" + tag);
        } else {
            displayTag.m_128405_(tag, defaultColor);
        }
    }

    private int getColorTag(@NotNull ItemStack stack, String tag, int defaultColor) {
        CompoundTag compoundTag = stack.m_41737_("display");
        return compoundTag != null && compoundTag.m_128425_(tag, 99) ? compoundTag.m_128451_(tag) : defaultColor;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void undoColor(ItemStack stack, int buttonIndex) {
        Item item = stack.m_41720_();
        if (item instanceof TenguMaskItem) {
            TenguMaskItem TenguMaskItem2 = (TenguMaskItem)item;
            switch (buttonIndex) {
                case 0: {
                    TenguMaskItem2.undoColorTag(stack, PRIMARY_PART, 0xFFFFFF);
                    break;
                }
                case 1: {
                    TenguMaskItem2.undoColorTag(stack, SECONDARY_PART, 0xFFFFFF);
                    break;
                }
                case 2: {
                    TenguMaskItem2.undoColorTag(stack, GOLD_PART, 0xFFFFFF);
                    break;
                }
                case 3: {
                    TenguMaskItem2.undoColorTag(stack, SILVER_PART, 0xFFFFFF);
                    break;
                }
            }
        }
    }
}

