/*
 * Decompiled with CFR 0.152.
 */
package net.alternativewill.kingdomsanddynasties2.util;

import java.util.List;

public class ColorCombiner {
    public static int combineColors(List<Integer> colors) {
        if (colors == null || colors.isEmpty()) {
            return 0;
        }
        int[] rgbTotals = new int[3];
        int maxBrightnessSum = 0;
        int count = colors.size();
        for (int color : colors) {
            int r = ColorCombiner.extractRed(color);
            int g = ColorCombiner.extractGreen(color);
            int b = ColorCombiner.extractBlue(color);
            rgbTotals[0] = rgbTotals[0] + r;
            rgbTotals[1] = rgbTotals[1] + g;
            rgbTotals[2] = rgbTotals[2] + b;
            maxBrightnessSum += Math.max(r, Math.max(g, b));
        }
        float avgR = (float)rgbTotals[0] / (float)count;
        float avgG = (float)rgbTotals[1] / (float)count;
        float avgB = (float)rgbTotals[2] / (float)count;
        float brightnessFactor = (float)maxBrightnessSum / (float)count;
        float maxComponent = Math.max(avgR, Math.max(avgG, avgB));
        if (maxComponent > 0.0f) {
            avgR = ColorCombiner.adjustComponent(avgR, brightnessFactor, maxComponent);
            avgG = ColorCombiner.adjustComponent(avgG, brightnessFactor, maxComponent);
            avgB = ColorCombiner.adjustComponent(avgB, brightnessFactor, maxComponent);
        }
        return ColorCombiner.packColor(avgR, avgG, avgB);
    }

    private static int extractRed(int color) {
        return color >> 16 & 0xFF;
    }

    private static int extractGreen(int color) {
        return color >> 8 & 0xFF;
    }

    private static int extractBlue(int color) {
        return color & 0xFF;
    }

    private static float adjustComponent(float component, float brightnessFactor, float maxComponent) {
        return Math.min(255.0f, component * brightnessFactor / maxComponent);
    }

    private static int packColor(float r, float g, float b) {
        return (int)r << 16 | (int)g << 8 | (int)b;
    }
}

