/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common;

import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.crowdcontrol.common.SoftLockConfig;
import dev.qixils.relocated.annotations.NotNull;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;

public abstract class SoftLockObserver<P> {
    protected static final Component ALERT = Plugin.output((Component)Component.translatable((String)"cc.soft-lock.output"));
    private final Map<UUID, DeathData> deathData = new HashMap<UUID, DeathData>();
    protected final Plugin<P, ?> plugin;

    protected SoftLockObserver(Plugin<P, ?> plugin) {
        this.plugin = plugin;
    }

    protected int getSearchH() {
        return this.plugin.getSoftLockConfig().getSearchH();
    }

    protected int getSearchV() {
        return this.plugin.getSoftLockConfig().getSearchV();
    }

    public abstract void onSoftLock(P var1);

    protected void onDeath(P player) {
        UUID uuid = this.plugin.playerMapper().tryGetUniqueId(player).orElseThrow(() -> new IllegalArgumentException("Expected player to have a UUID"));
        DeathData data = this.deathData.computeIfAbsent(uuid, $ -> new DeathData(this.plugin.getSoftLockConfig()));
        if (data.isSoftLocked()) {
            this.onSoftLock(player);
            this.deathData.remove(uuid);
        }
    }

    private static final class DeathData {
        private final List<LocalDateTime> deaths = new ArrayList<LocalDateTime>();
        @NotNull
        private final SoftLockConfig config;

        public DeathData(@NotNull SoftLockConfig config) {
            this.config = config;
            this.addDeath();
        }

        private void addDeath() {
            LocalDateTime now = LocalDateTime.now();
            this.deaths.removeIf(d -> d.isBefore(now.minus(this.config.getPeriod())));
            this.deaths.add(now);
        }

        public boolean isSoftLocked() {
            this.addDeath();
            return this.deaths.size() >= this.config.getDeaths();
        }
    }
}

