/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.command.impl.exp;

import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.crowdcontrol.common.command.Command;
import dev.qixils.crowdcontrol.common.command.QuantityStyle;
import dev.qixils.crowdcontrol.common.mc.MCCCPlayer;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;

public class ExpSubCommand<P>
implements Command<P> {
    @NotNull
    private final String effectName = "xp_sub";
    @NotNull
    private final QuantityStyle quantityStyle = QuantityStyle.APPEND;
    @NotNull
    private final Plugin<P, ?> plugin;

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull P>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        int amount = request.getQuantity();
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            boolean success = false;
            for (Object rawPlayer : players) {
                MCCCPlayer player = this.plugin.getPlayer(rawPlayer);
                int curLevel = player.xpLevel();
                int newLevel = curLevel - amount;
                if (newLevel < 0) continue;
                this.sync(() -> player.xpLevel(newLevel));
                success = true;
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Player does not have enough XP levels");
        }));
    }

    @Override
    @NotNull
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @NotNull
    @Generated
    public QuantityStyle getQuantityStyle() {
        return this.quantityStyle;
    }

    @Override
    @NotNull
    @Generated
    public Plugin<P, ?> getPlugin() {
        return this.plugin;
    }

    @Generated
    public ExpSubCommand(@NotNull Plugin<P, ?> plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.plugin = plugin;
    }
}

