/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.TriState;
import dev.qixils.crowdcontrol.common.Global;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.IUserRecord;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.minecraft.class_1267;
import net.minecraft.class_3222;

@Global
public class DifficultyCommand
extends ModdedCommand {
    private final class_1267 difficulty;
    private final String effectName;
    private final Component displayName;

    private static String effectNameOf(class_1267 difficulty) {
        return "difficulty_" + difficulty.method_5460();
    }

    public DifficultyCommand(ModdedCrowdControlPlugin plugin, class_1267 difficulty) {
        super(plugin);
        this.difficulty = difficulty;
        this.effectName = DifficultyCommand.effectNameOf(difficulty);
        this.displayName = Component.translatable((String)"cc.effect.difficulty.name", (ComponentLike[])new ComponentLike[]{plugin.toAdventure(difficulty.method_5463())});
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            playerSupplier.get();
            if (this.plugin.server().method_27728().method_197()) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_PERMANENT, "Server difficulty is locked");
            }
            if (this.plugin.server().method_27728().method_207() == this.difficulty) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Server difficulty is already set to " + String.valueOf(this.displayName));
            }
            this.async(this.plugin::updateConditionalEffectVisibility);
            this.sync(() -> this.plugin.server().method_3776(this.difficulty, true));
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
        }));
    }

    @Override
    public TriState isVisible(@NotNull IUserRecord user, @NotNull List<class_3222> potentialPlayers) {
        if (this.plugin.server().method_27728().method_197()) {
            return TriState.FALSE;
        }
        return TriState.TRUE;
    }

    @Override
    public TriState isSelectable(@NotNull IUserRecord user, @NotNull List<class_3222> potentialPlayers) {
        if (this.plugin.server().method_27728().method_207() == this.difficulty) {
            return TriState.FALSE;
        }
        return TriState.TRUE;
    }

    @Generated
    public class_1267 getDifficulty() {
        return this.difficulty;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @Generated
    public Component getDisplayName() {
        return this.displayName;
    }
}

