/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.AttributeUtil;
import dev.qixils.crowdcontrol.plugin.fabric.utils.Location;
import dev.qixils.relocated.annotations.NotNull;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;

public class EntitySizeCommand
extends ModdedCommand {
    private final Duration defaultDuration = Duration.ofSeconds(30L);
    private final String effectName;
    private final double level;
    private static final double radius = Math.pow(30.0, 2.0);

    public EntitySizeCommand(ModdedCrowdControlPlugin plugin, String effectName, double level) {
        super(plugin);
        this.effectName = effectName;
        this.level = level;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            MinecraftServer server = this.plugin.getServer();
            if (server == null) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Server not active");
            }
            Set locations = ((List)playerSupplier.get()).stream().map(Location::new).collect(Collectors.toSet());
            boolean success = false;
            for (class_3218 world : this.plugin.getServer().method_3738()) {
                block1: for (class_1297 entity : world.method_27909()) {
                    if (!(entity instanceof class_1309)) continue;
                    class_1309 living = (class_1309)entity;
                    if (entity instanceof class_1657) continue;
                    Location entityLoc = new Location(entity);
                    for (Location loc : locations) {
                        if (!Objects.equals(loc.level(), entityLoc.level()) || loc.squareDistanceTo(entityLoc) > radius || AttributeUtil.getModifier(living, (class_6880<class_1320>)class_5134.field_47760, CommandConstants.SCALE_MODIFIER_UUID).map(class_1322::comp_2449).orElse(0.0) == this.level) continue;
                        AttributeUtil.addModifier(living, (class_6880<class_1320>)class_5134.field_47760, CommandConstants.SCALE_MODIFIER_UUID, this.level, class_1322.class_1323.field_6330, true);
                        success = true;
                        continue block1;
                    }
                }
            }
            if (!success) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Could not find entities to resize");
            }
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
        }, this.plugin.getSyncExecutor()));
    }

    public static EntitySizeCommand increase(ModdedCrowdControlPlugin plugin) {
        return new EntitySizeCommand(plugin, "entity_size_double", 1.0);
    }

    public static EntitySizeCommand decrease(ModdedCrowdControlPlugin plugin) {
        return new EntitySizeCommand(plugin, "entity_size_halve", -0.5);
    }

    @Generated
    public Duration getDefaultDuration() {
        return this.defaultDuration;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Generated
    public double getLevel() {
        return this.level;
    }
}

