/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.EventListener;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.event.Join;
import dev.qixils.crowdcontrol.plugin.fabric.event.Listener;
import dev.qixils.relocated.annotations.NotNull;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1656;
import net.minecraft.class_1934;
import net.minecraft.class_243;
import net.minecraft.class_3222;

@EventListener
public class FlightCommand
extends ModdedCommand
implements CCTimedEffect {
    private final String effectName = "flight";
    private final Duration defaultDuration = Duration.ofSeconds(15L);
    private final String effectGroup = "gamemode";
    private final List<String> effectGroups = Collections.singletonList("gamemode");
    private final Map<UUID, List<UUID>> uuidMap = new HashMap<UUID, List<UUID>>();

    public FlightCommand(@NotNull ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            boolean success = false;
            for (class_3222 player : players) {
                class_1934 gamemode = player.field_13974.method_14257();
                if (gamemode == class_1934.field_9220 || gamemode == class_1934.field_9219) continue;
                class_1656 abilities = player.method_31549();
                if (abilities.field_7478 || abilities.field_7479) continue;
                success = true;
                this.sync(() -> {
                    abilities.field_7478 = true;
                    abilities.field_7479 = true;
                    player.method_45319(new class_243(0.0, 0.2, 0.0));
                    player.field_6037 = true;
                    player.method_7355();
                });
            }
            if (!success) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Target is already flying or able to fly");
            }
            this.uuidMap.put(request.getRequestId(), players.stream().map(class_1297::method_5667).toList());
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }));
    }

    @Override
    public void onEnd(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        List<class_3222> players = this.plugin.toPlayerList((Collection<UUID>)this.uuidMap.remove(request.getRequestId()));
        this.sync(() -> players.forEach(player -> {
            class_1656 abilities = player.method_31549();
            abilities.field_7478 = false;
            abilities.field_7479 = false;
            player.method_7355();
        }));
    }

    @Listener
    public void onJoin(Join event) {
        class_3222 player = event.player();
        class_1934 gamemode = player.field_13974.method_14257();
        if (gamemode == class_1934.field_9220) {
            return;
        }
        if (gamemode == class_1934.field_9219) {
            return;
        }
        class_1656 abilities = player.method_31549();
        if (!abilities.field_7479 && !abilities.field_7478) {
            return;
        }
        abilities.field_7478 = false;
        abilities.field_7479 = false;
        player.method_7355();
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Generated
    public Duration getDefaultDuration() {
        return this.defaultDuration;
    }

    @Generated
    public String getEffectGroup() {
        return this.effectGroup;
    }

    @Override
    @Generated
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }

    @Generated
    public Map<UUID, List<UUID>> getUuidMap() {
        return this.uuidMap;
    }
}

