/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.EventListener;
import dev.qixils.crowdcontrol.common.components.MovementStatusType;
import dev.qixils.crowdcontrol.common.components.MovementStatusValue;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.event.Death;
import dev.qixils.crowdcontrol.plugin.fabric.event.Listener;
import dev.qixils.crowdcontrol.plugin.fabric.utils.Location;
import dev.qixils.relocated.annotations.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.CrowdControl;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class FreezeCommand
extends ModdedCommand
implements CCTimedEffect {
    public static final Map<UUID, List<FreezeData>> DATA = new HashMap<UUID, List<FreezeData>>();
    private static final Map<UUID, Map<UUID, FreezeData>> TIMED_EFFECTS = new HashMap<UUID, Map<UUID, FreezeData>>();
    private final String effectName;
    private final String effectGroup;
    private final List<String> effectGroups;
    private final LocationModifier modifier;
    private final MovementStatusType freezeType;
    private final MovementStatusValue freezeValue;

    public FreezeCommand(ModdedCrowdControlPlugin plugin, String effectName, String effectGroup, LocationModifier modifier, MovementStatusType freezeType, MovementStatusValue freezeValue) {
        super(plugin);
        this.effectName = effectName;
        this.effectGroup = effectGroup;
        this.effectGroups = Collections.singletonList(effectGroup);
        this.modifier = modifier;
        this.freezeType = freezeType;
        this.freezeValue = freezeValue;
    }

    public FreezeCommand(ModdedCrowdControlPlugin plugin, String effectName, LocationModifier modifier, MovementStatusType freezeType, MovementStatusValue freezeValue) {
        this(plugin, effectName, effectName, modifier, freezeType, freezeValue);
    }

    public FreezeCommand(ModdedCrowdControlPlugin plugin, String effectName, String effectGroup, LocationModifier modifier, MovementStatusType freezeType) {
        this(plugin, effectName, effectGroup, modifier, freezeType, MovementStatusValue.DENIED);
    }

    public FreezeCommand(ModdedCrowdControlPlugin plugin, String effectName, LocationModifier modifier, MovementStatusType freezeType) {
        this(plugin, effectName, effectName, modifier, freezeType);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            if (this.isActive(ccPlayer, this.getEffectArray())) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Conflicting effects active");
            }
            List players = (List)playerSupplier.get();
            HashMap locations = new HashMap();
            players.forEach(player -> {
                UUID uuid = player.method_5667();
                FreezeData data = new FreezeData(this.modifier, new Location((class_1297)player));
                locations.put(uuid, data);
                DATA.computeIfAbsent(uuid, $2 -> new ArrayList()).add(data);
                player.cc$setMovementStatus(this.freezeType, this.freezeValue);
            });
            TIMED_EFFECTS.put(request.getRequestId(), locations);
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }));
    }

    @Override
    public void onEnd(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        Map<UUID, FreezeData> locations = TIMED_EFFECTS.remove(request.getRequestId());
        if (locations == null) {
            return;
        }
        MinecraftServer server = this.getPlugin().getServer();
        if (server == null) {
            return;
        }
        locations.forEach((uuid, data) -> {
            DATA.get(uuid).remove(data);
            class_3222 player = server.method_3760().method_14602(uuid);
            if (player == null) {
                return;
            }
            player.cc$setMovementStatus(this.freezeType, MovementStatusValue.ALLOWED);
        });
    }

    public static FreezeCommand feet(ModdedCrowdControlPlugin plugin) {
        return new FreezeCommand(plugin, "freeze", "walk", (newLocation, previousLocation) -> previousLocation.withRotationOf(newLocation), MovementStatusType.WALK);
    }

    public static FreezeCommand camera(ModdedCrowdControlPlugin plugin) {
        return new FreezeCommand(plugin, "camera_lock", "look", Location::withRotationOf, MovementStatusType.LOOK);
    }

    public static FreezeCommand skyCamera(ModdedCrowdControlPlugin plugin) {
        return new FreezeCommand(plugin, "camera_lock_to_sky", "look", (cur, prev) -> cur.withRotation(cur.yaw(), -90.0f), MovementStatusType.LOOK, MovementStatusValue.PARTIAL);
    }

    public static FreezeCommand groundCamera(ModdedCrowdControlPlugin plugin) {
        return new FreezeCommand(plugin, "camera_lock_to_ground", "look", (cur, prev) -> cur.withRotation(cur.yaw(), 90.0f), MovementStatusType.LOOK, MovementStatusValue.PARTIAL);
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Generated
    public String getEffectGroup() {
        return this.effectGroup;
    }

    @Override
    @Generated
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }

    @Generated
    public LocationModifier getModifier() {
        return this.modifier;
    }

    @Generated
    public MovementStatusType getFreezeType() {
        return this.freezeType;
    }

    @Generated
    public MovementStatusValue getFreezeValue() {
        return this.freezeValue;
    }

    @FunctionalInterface
    public static interface LocationModifier
    extends BiFunction<Location, Location, Location> {
        @Override
        public Location apply(@NotNull Location var1, @NotNull Location var2);
    }

    public static final class FreezeData {
        public final LocationModifier modifier;
        public Location previousLocation;

        public Location getDestination(Location currentLocation) {
            return this.modifier.apply(currentLocation, this.previousLocation);
        }

        @Generated
        public FreezeData(LocationModifier modifier, Location previousLocation) {
            this.modifier = modifier;
            this.previousLocation = previousLocation;
        }
    }

    @EventListener
    public static final class Manager {
        private final ModdedCrowdControlPlugin plugin;

        @Listener
        public void onDeath(Death death) {
            CrowdControl cc = this.plugin.getCrowdControl();
            if (cc == null) {
                return;
            }
            UUID uuid = death.entity().method_5667();
            Set<UUID> requestIds = TIMED_EFFECTS.entrySet().stream().filter(entry -> ((Map)entry.getValue()).containsKey(uuid)).map(Map.Entry::getKey).collect(Collectors.toSet());
            requestIds.forEach(cc::cancelByRequestId);
        }

        @Generated
        public Manager(ModdedCrowdControlPlugin plugin) {
            this.plugin = plugin;
        }
    }
}

