/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.components.MovementStatusType;
import dev.qixils.crowdcontrol.common.components.MovementStatusValue;
import dev.qixils.crowdcontrol.common.util.ComparableUtil;
import dev.qixils.crowdcontrol.common.util.SemVer;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public class MovementStatusCommand
extends ModdedCommand
implements CCTimedEffect {
    private final String effectName;
    private final String effectGroup;
    private final Duration defaultDuration;
    private final MovementStatusType type;
    private final MovementStatusValue value;
    private final SemVer minimumModVersion;
    private final Map<UUID, Set<UUID>> idMap = new HashMap<UUID, Set<UUID>>();

    public MovementStatusCommand(ModdedCrowdControlPlugin plugin, String effectName, String effectGroup, Duration defaultDuration, MovementStatusType type, MovementStatusValue value, boolean clientOnly) {
        super(plugin);
        this.effectName = effectName;
        this.effectGroup = effectGroup;
        this.defaultDuration = defaultDuration;
        this.type = type;
        this.value = value;
        this.minimumModVersion = clientOnly ? ComparableUtil.max(type.addedIn(), value.addedIn()) : SemVer.ZERO;
    }

    public MovementStatusCommand(ModdedCrowdControlPlugin plugin, String effectName, Duration defaultDuration, MovementStatusType type, MovementStatusValue value, boolean clientOnly) {
        this(plugin, effectName, effectName, defaultDuration, type, value, clientOnly);
    }

    @Override
    public void execute(@NotNull Supplier<List<class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            this.idMap.put(request.getRequestId(), players.stream().map(class_1297::method_5667).collect(Collectors.toSet()));
            for (class_1657 player : players) {
                player.cc$setMovementStatus(this.type, this.value);
            }
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }));
    }

    @Override
    public void onEnd(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        this.plugin.toPlayerStream((Collection<UUID>)this.idMap.remove(request.getRequestId())).forEach(player -> player.cc$setMovementStatus(this.type, MovementStatusValue.ALLOWED));
    }

    public static MovementStatusCommand disableJumping(ModdedCrowdControlPlugin plugin) {
        return new MovementStatusCommand(plugin, "disable_jumping", CommandConstants.DISABLE_JUMPING_DURATION, MovementStatusType.JUMP, MovementStatusValue.DENIED, false);
    }

    public static MovementStatusCommand invertControls(ModdedCrowdControlPlugin plugin) {
        return new MovementStatusCommand(plugin, "invert_wasd", "walk", CommandConstants.INVERT_CONTROLS_DURATION, MovementStatusType.WALK, MovementStatusValue.INVERTED, true);
    }

    public static MovementStatusCommand invertCamera(ModdedCrowdControlPlugin plugin) {
        return new MovementStatusCommand(plugin, "invert_look", "look", CommandConstants.INVERT_CONTROLS_DURATION, MovementStatusType.LOOK, MovementStatusValue.INVERTED, true);
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Generated
    public String getEffectGroup() {
        return this.effectGroup;
    }

    @Generated
    public Duration getDefaultDuration() {
        return this.defaultDuration;
    }

    @Generated
    public MovementStatusType getType() {
        return this.type;
    }

    @Generated
    public MovementStatusValue getValue() {
        return this.value;
    }

    @Override
    @Generated
    public SemVer getMinimumModVersion() {
        return this.minimumModVersion;
    }

    @Generated
    public Map<UUID, Set<UUID>> getIdMap() {
        return this.idMap;
    }
}

