/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.EventListener;
import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.common.util.sound.Sounds;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.event.Listener;
import dev.qixils.crowdcontrol.plugin.fabric.event.Tick;
import dev.qixils.relocated.annotations.NotNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.sound.Sound;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_3222;
import net.minecraft.class_3441;
import net.minecraft.class_3908;
import net.minecraft.class_3917;

@EventListener
public final class ToastCommand
extends ModdedCommand {
    private static final class_1792[] MATERIALS = new class_1792[]{class_1802.field_8501, class_1802.field_8879, class_1802.field_8761, class_1802.field_8703, class_1802.field_8581, class_1802.field_8656, class_1802.field_8085, class_1802.field_8196, class_1802.field_8747, class_1802.field_8739, class_1802.field_8119, class_1802.field_8500, class_1802.field_8736, class_1802.field_8240, class_1802.field_8871, class_1802.field_8157};
    private static final int INVENTORY_SIZE = 27;
    private static final Map<UUID, ToastInventory> OPEN_INVENTORIES = new HashMap<UUID, ToastInventory>();
    private static class_2561 TITLE;
    private final String effectName = "toast";

    public ToastCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
        TITLE = plugin.adventure().asNative(CommandConstants.POPUP_TITLE);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            for (class_3222 player : (List)playerSupplier.get()) {
                player.playSound(Sounds.ANNOYING.get(new Object[0]), Sound.Emitter.self());
                class_3441 book = player.method_14253();
                class_1863 recipeManager = this.plugin.server().method_3772();
                List recipes = book.field_54550.stream().flatMap(location -> recipeManager.method_8130(location).stream()).toList();
                book.method_14900(recipes, player);
                book.method_14903(recipes, player);
                class_1277 container = new class_1277(27);
                ToastInventory toastInv = new ToastInventory((class_1263)container);
                toastInv.tick();
                player.method_17355((class_3908)new ToastMenuProvider((class_1263)container));
                OPEN_INVENTORIES.put(player.method_5667(), toastInv);
            }
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
        }, this.plugin.getSyncExecutor()));
    }

    @Listener
    public void onTick(@NotNull Tick tick) {
        OPEN_INVENTORIES.values().forEach(ToastInventory::tick);
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    private static final class ToastInventory {
        @NotNull
        private final class_1263 inventory;
        private int index = 0;

        private ToastInventory(@NotNull class_1263 inventory) {
            this.inventory = inventory;
        }

        public void tick() {
            class_1792 item = MATERIALS[this.index++ % MATERIALS.length];
            for (int i = 0; i < 27; ++i) {
                this.inventory.method_5447(i, new class_1799((class_1935)item));
            }
        }
    }

    private record ToastMenuProvider(@NotNull class_1263 container) implements class_3908
    {
        @NotNull
        public class_2561 method_5476() {
            return TITLE;
        }

        public class_1703 createMenu(int i, @NotNull class_1661 inventory, @NotNull class_1657 player) {
            return new ToastMenu(i, inventory, this.container);
        }
    }

    private static final class ToastMenu
    extends class_1707 {
        public ToastMenu(int i, @NotNull class_1661 inventory, @NotNull class_1263 container) {
            super(class_3917.field_17326, i, inventory, container, 3);
        }

        public void method_7595(@NotNull class_1657 player) {
            super.method_7595(player);
            OPEN_INVENTORIES.remove(player.method_5667());
        }

        public void method_7593(int slotIndex, int buttonIndex, @NotNull class_1713 clickType, @NotNull class_1657 player) {
            if (!(player instanceof class_3222)) {
                return;
            }
            class_3222 sPlayer = (class_3222)player;
            sPlayer.field_7512.method_34252();
            sPlayer.field_13987.method_14364((class_2596)new class_2653(-1, -1, sPlayer.field_7498.method_37422(), sPlayer.field_7512.method_34255()));
            if (slotIndex >= 0 && slotIndex < sPlayer.field_7512.field_7761.size()) {
                sPlayer.field_13987.method_14364((class_2596)new class_2653(sPlayer.field_7512.field_7763, sPlayer.field_7498.method_37422(), slotIndex, sPlayer.field_7512.method_7611(slotIndex).method_7677()));
            }
        }
    }
}

