/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.BlockFinder;
import dev.qixils.crowdcontrol.plugin.fabric.utils.Location;
import dev.qixils.crowdcontrol.plugin.fabric.utils.TypedTag;
import dev.qixils.relocated.annotations.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2555;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class TorchCommand
extends ModdedCommand {
    protected static final class_2350[] BLOCK_FACES = new class_2350[]{class_2350.field_11033, class_2350.field_11034, class_2350.field_11039, class_2350.field_11035, class_2350.field_11043};
    protected final TypedTag<class_2248> torches;
    protected final boolean placeTorches;
    protected final String effectName;

    public TorchCommand(ModdedCrowdControlPlugin plugin, boolean placeTorches) {
        super(plugin);
        this.placeTorches = placeTorches;
        this.effectName = placeTorches ? "lit" : "dim";
        this.torches = new TypedTag(CommandConstants.TORCHES, class_7923.field_41175);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            Predicate<Location> predicate = this.placeTorches ? loc -> BlockFinder.isReplaceable(loc.block()) : loc -> this.torches.contains(loc.block().method_26204());
            ArrayList nearbyBlocks = new ArrayList();
            ((List)playerSupplier.get()).forEach(player -> nearbyBlocks.addAll(((BlockFinder.BlockFinderBuilder)((BlockFinder.BlockFinderBuilder)((BlockFinder.BlockFinderBuilder)BlockFinder.builder().origin((class_1297)player).maxRadius(5)).locationValidator(predicate)).shuffleLocations(false)).build().getAll()));
            if (nearbyBlocks.isEmpty()) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No available blocks to place/remove");
            }
            this.sync(() -> {
                for (Location location : nearbyBlocks) {
                    if (this.placeTorches) {
                        this.placeTorch(location);
                        continue;
                    }
                    location.block(class_2246.field_10124.method_9564());
                }
            });
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
        }));
    }

    protected void placeTorch(Location location) {
        class_2350 placeFace = null;
        for (class_2350 blockFace : BLOCK_FACES) {
            class_2680 target = location.relative(blockFace == class_2350.field_11033 ? blockFace : blockFace.method_10153()).block();
            if (!BlockFinder.isSolid(target)) continue;
            placeFace = blockFace;
            break;
        }
        if (placeFace == null) {
            return;
        }
        class_2680 setBlock = placeFace == class_2350.field_11033 ? class_2246.field_10336.method_9564() : (class_2680)class_2246.field_10099.method_9564().method_11657((class_2769)class_2555.field_11731, placeFace);
        location.block(setBlock);
    }

    @Generated
    public TypedTag<class_2248> getTorches() {
        return this.torches;
    }

    @Generated
    public boolean isPlaceTorches() {
        return this.placeTorches;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }
}

