/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.configurate;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.Nullable;
import dev.qixils.relocated.configurate.AbstractConfigurationNode;
import dev.qixils.relocated.configurate.ConfigurationOptions;
import dev.qixils.relocated.configurate.ConfigurationVisitor;
import dev.qixils.relocated.configurate.NodePath;
import dev.qixils.relocated.configurate.RepresentationHint;
import dev.qixils.relocated.configurate.serialize.Scalars;
import dev.qixils.relocated.configurate.serialize.SerializationException;
import dev.qixils.relocated.configurate.util.Types;
import io.leangen.geantyref.TypeFactory;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collector;

public interface ConfigurationNode {
    public static final int NUMBER_DEF = 0;

    public @Nullable Object key();

    public NodePath path();

    public @Nullable ConfigurationNode parent();

    public ConfigurationNode node(Object ... var1);

    public ConfigurationNode node(Iterable<?> var1);

    public boolean hasChild(Object ... var1);

    public boolean hasChild(Iterable<?> var1);

    public boolean virtual();

    public ConfigurationOptions options();

    public boolean isNull();

    public boolean isList();

    public boolean isMap();

    public boolean empty();

    public List<? extends ConfigurationNode> childrenList();

    public Map<Object, ? extends ConfigurationNode> childrenMap();

    default public <V> Collector<Map.Entry<?, V>, ? extends ConfigurationNode, ? extends ConfigurationNode> toMapCollector(TypeToken<V> valueType) {
        return Collector.of(() -> this, (node, entry) -> {
            try {
                node.node(entry.getKey()).set(valueType, entry.getValue());
            }
            catch (SerializationException e) {
                throw new IllegalArgumentException(e);
            }
        }, ConfigurationNode::mergeFrom, new Collector.Characteristics[0]);
    }

    default public <V> Collector<Map.Entry<?, V>, ? extends ConfigurationNode, ? extends ConfigurationNode> toMapCollector(Class<V> valueType) {
        return Collector.of(() -> this, (node, entry) -> {
            try {
                node.node(entry.getKey()).set(valueType, entry.getValue());
            }
            catch (SerializationException e) {
                throw new IllegalArgumentException(e);
            }
        }, ConfigurationNode::mergeFrom, new Collector.Characteristics[0]);
    }

    default public <V> Collector<V, ? extends ConfigurationNode, ? extends ConfigurationNode> toListCollector(TypeToken<V> valueType) {
        return Collector.of(() -> this, (node, value) -> {
            try {
                node.appendListNode().set(valueType, value);
            }
            catch (SerializationException e) {
                throw new IllegalArgumentException(e);
            }
        }, ConfigurationNode::mergeFrom, new Collector.Characteristics[0]);
    }

    default public <V> Collector<V, ? extends ConfigurationNode, ? extends ConfigurationNode> toListCollector(Class<V> valueType) {
        return Collector.of(() -> this, (node, value) -> {
            try {
                node.appendListNode().set(valueType, value);
            }
            catch (SerializationException e) {
                throw new IllegalArgumentException(e);
            }
        }, ConfigurationNode::mergeFrom, new Collector.Characteristics[0]);
    }

    default public <V> V require(TypeToken<V> type) throws SerializationException {
        @Nullable V ret = this.get(type);
        if (ret == null) {
            throw new NoSuchElementException("Node value was null when a non-null node was require()d");
        }
        return ret;
    }

    default public <V> V require(Class<V> type) throws SerializationException {
        @Nullable V ret = this.get(type);
        if (ret == null) {
            throw new NoSuchElementException("Node value was null when a non-null node was require()d");
        }
        return ret;
    }

    default public Object require(Type type) throws SerializationException {
        @Nullable Object ret = this.get(type);
        if (ret == null) {
            throw new NoSuchElementException("Node value was null when a non-null node was require()d");
        }
        return ret;
    }

    default public <V> @Nullable V get(TypeToken<V> type) throws SerializationException {
        return (V)this.get(type.getAnnotatedType());
    }

    default public <V> V get(TypeToken<V> type, V def) throws SerializationException {
        return (V)this.get(type.getAnnotatedType(), def);
    }

    default public <V> V get(TypeToken<V> type, Supplier<V> defSupplier) throws SerializationException {
        return (V)this.get(type.getAnnotatedType(), defSupplier);
    }

    default public <V> @Nullable V get(Class<V> type) throws SerializationException {
        return (V)this.get((Type)type);
    }

    default public <V> V get(Class<V> type, V def) throws SerializationException {
        return (V)this.get((Type)type, (Object)def);
    }

    default public <V> V get(Class<V> type, Supplier<V> defSupplier) throws SerializationException {
        return (V)this.get((Type)type, (Supplier<?>)defSupplier);
    }

    public @Nullable Object get(AnnotatedType var1) throws SerializationException;

    public Object get(AnnotatedType var1, Object var2) throws SerializationException;

    public Object get(AnnotatedType var1, Supplier<?> var2) throws SerializationException;

    public @Nullable Object get(Type var1) throws SerializationException;

    public Object get(Type var1, Object var2) throws SerializationException;

    public Object get(Type var1, Supplier<?> var2) throws SerializationException;

    default public <V> @Nullable List<V> getList(TypeToken<V> type) throws SerializationException {
        return this.get(Types.makeListType(type));
    }

    default public <V> List<V> getList(TypeToken<V> elementType, List<V> def) throws SerializationException {
        TypeToken<List<V>> type = Types.makeListType(elementType);
        List<V> ret = this.get(type, def);
        return ret.isEmpty() ? AbstractConfigurationNode.storeDefault(this, type.getType(), def) : ret;
    }

    default public <V> List<V> getList(TypeToken<V> elementType, Supplier<List<V>> defSupplier) throws SerializationException {
        TypeToken<List<V>> type = Types.makeListType(elementType);
        List<V> ret = this.get(type, defSupplier);
        return ret.isEmpty() ? AbstractConfigurationNode.storeDefault(this, type.getType(), defSupplier.get()) : ret;
    }

    default public <V> @Nullable List<V> getList(Class<V> type) throws SerializationException {
        return (List)this.get(TypeFactory.parameterizedClass(List.class, type));
    }

    default public <V> List<V> getList(Class<V> elementType, List<V> def) throws SerializationException {
        Type type = TypeFactory.parameterizedClass(List.class, elementType);
        List<V> ret = (List<V>)this.get(type, def);
        return ret.isEmpty() ? AbstractConfigurationNode.storeDefault(this, type, def) : ret;
    }

    default public <V> List<V> getList(Class<V> elementType, Supplier<List<V>> defSupplier) throws SerializationException {
        Type type = TypeFactory.parameterizedClass(List.class, elementType);
        List<V> ret = (List<V>)this.get(type, defSupplier);
        return ret.isEmpty() ? AbstractConfigurationNode.storeDefault(this, type, defSupplier.get()) : ret;
    }

    default public @Nullable String getString() {
        return Scalars.STRING.tryDeserialize(this.rawScalar());
    }

    default public String getString(String def) {
        Objects.requireNonNull(def, "def");
        @Nullable String value = this.getString();
        if (value != null) {
            return value;
        }
        if (this.options().shouldCopyDefaults()) {
            Scalars.STRING.serialize((Type)((Object)String.class), def, this);
        }
        return def;
    }

    default public float getFloat() {
        return this.getFloat(0.0f);
    }

    default public float getFloat(float def) {
        @Nullable Float val = Scalars.FLOAT.tryDeserialize(this.rawScalar());
        if (val != null) {
            return val.floatValue();
        }
        if (this.options().shouldCopyDefaults() && def != 0.0f) {
            Scalars.FLOAT.serialize((Type)Float.TYPE, Float.valueOf(def), this);
        }
        return def;
    }

    default public double getDouble() {
        return this.getDouble(0.0);
    }

    default public double getDouble(double def) {
        @Nullable Double val = Scalars.DOUBLE.tryDeserialize(this.rawScalar());
        if (val != null) {
            return val;
        }
        if (this.options().shouldCopyDefaults() && def != 0.0) {
            Scalars.DOUBLE.serialize((Type)Double.TYPE, (Double)def, this);
        }
        return def;
    }

    default public int getInt() {
        return this.getInt(0);
    }

    default public int getInt(int def) {
        @Nullable Integer val = Scalars.INTEGER.tryDeserialize(this.rawScalar());
        if (val != null) {
            return val;
        }
        if (this.options().shouldCopyDefaults() && def != 0) {
            Scalars.INTEGER.serialize((Type)Integer.TYPE, (Integer)def, this);
        }
        return def;
    }

    default public long getLong() {
        return this.getLong(0L);
    }

    default public long getLong(long def) {
        @Nullable Long val = Scalars.LONG.tryDeserialize(this.rawScalar());
        if (val != null) {
            return val;
        }
        if (this.options().shouldCopyDefaults() && def != 0L) {
            Scalars.LONG.serialize((Type)Long.TYPE, (Long)def, this);
        }
        return def;
    }

    default public boolean getBoolean() {
        return this.getBoolean(false);
    }

    default public boolean getBoolean(boolean def) {
        @Nullable Boolean val = Scalars.BOOLEAN.tryDeserialize(this.rawScalar());
        if (val != null) {
            return val;
        }
        if (this.options().shouldCopyDefaults()) {
            Scalars.BOOLEAN.serialize((Type)Boolean.TYPE, (Boolean)def, this);
        }
        return def;
    }

    public ConfigurationNode set(@Nullable Object var1) throws SerializationException;

    public <V> ConfigurationNode set(TypeToken<V> var1, @Nullable V var2) throws SerializationException;

    public <V> ConfigurationNode set(Class<V> var1, @Nullable V var2) throws SerializationException;

    public ConfigurationNode set(Type var1, @Nullable Object var2) throws SerializationException;

    public ConfigurationNode set(AnnotatedType var1, @Nullable Object var2) throws SerializationException;

    default public <V> ConfigurationNode setList(Class<V> elementType, @Nullable List<V> items) throws SerializationException {
        return this.set(TypeFactory.parameterizedClass(List.class, elementType), items);
    }

    default public <V> ConfigurationNode setList(TypeToken<V> elementType, @Nullable List<V> items) throws SerializationException {
        return this.set(TypeFactory.parameterizedClass(List.class, elementType.getType()), items);
    }

    public @Nullable Object raw();

    public ConfigurationNode raw(@Nullable Object var1);

    public @Nullable Object rawScalar();

    public ConfigurationNode from(ConfigurationNode var1);

    public ConfigurationNode mergeFrom(ConfigurationNode var1);

    public boolean removeChild(Object var1);

    public ConfigurationNode appendListNode();

    public ConfigurationNode copy();

    default public <S, T, E extends Exception> T visit(ConfigurationVisitor<S, T, E> visitor) throws E {
        return this.visit(visitor, visitor.newState());
    }

    public <S, T, E extends Exception> T visit(ConfigurationVisitor<S, T, E> var1, S var2) throws E;

    default public <S, T> T visit(ConfigurationVisitor.Safe<S, T> visitor) {
        return this.visit(visitor, visitor.newState());
    }

    public <S, T> T visit(ConfigurationVisitor.Safe<S, T> var1, S var2);

    public <V> ConfigurationNode hint(RepresentationHint<V> var1, @Nullable V var2);

    public <V> @Nullable V hint(RepresentationHint<V> var1);

    public <V> @Nullable V ownHint(RepresentationHint<V> var1);

    public Map<RepresentationHint<?>, ?> ownHints();
}

