/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.util;

import dev.qixils.crowdcontrol.common.util.CCResponseException;
import dev.qixils.relocated.annotations.CheckReturnValue;
import dev.qixils.relocated.annotations.NotNull;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtil {
    private static final Logger log = LoggerFactory.getLogger(ThreadUtil.class);
    public static long TRY_FOR = 50000L;

    public static boolean sleep() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            return false;
        }
        return !Thread.interrupted();
    }

    @CheckReturnValue
    @NotNull
    public static CCEffectResponse waitForSuccess(@NotNull PublicEffectPayload request, Supplier<CCEffectResponse> supplier) {
        CCEffectResponse resp = null;
        long time = System.currentTimeMillis();
        int i = 0;
        while (System.currentTimeMillis() - time < TRY_FOR) {
            try {
                resp = supplier.get();
            }
            catch (CCResponseException e) {
                resp = e.getResponse();
            }
            catch (Exception e) {
                log.warn("Failed to supply", e);
            }
            if ((resp == null || resp.getStatus() != ResponseStatus.SUCCESS && resp.getStatus() != ResponseStatus.FAIL_PERMANENT && resp.getStatus() != ResponseStatus.TIMED_BEGIN) && (i++ <= 0 || ThreadUtil.sleep())) continue;
        }
        if (resp != null) {
            return resp;
        }
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Effect failed to execute");
    }

    @CheckReturnValue
    @NotNull
    public static CCEffectResponse waitForSuccess(@NotNull PublicEffectPayload request, Supplier<CCEffectResponse> supplier, @NotNull Executor executor) {
        return ThreadUtil.waitForSuccess(request, () -> (CCEffectResponse)CompletableFuture.supplyAsync(supplier, executor).join());
    }
}

