/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric;

import dev.qixils.crowdcontrol.common.VersionMetadata;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.packets.fabric.PacketUtilImpl;
import dev.qixils.crowdcontrol.plugin.fabric.util.FabricPermissionUtil;
import dev.qixils.crowdcontrol.plugin.fabric.utils.PermissionUtil;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.fabric.FabricServerCommandManager;

public class FabricCrowdControlPlugin
extends ModdedCrowdControlPlugin
implements ModInitializer {
    private final FabricServerCommandManager<class_2168> commandManager = FabricServerCommandManager.createNative((ExecutionCoordinator)ExecutionCoordinator.asyncCoordinator());
    private final PermissionUtil permissionUtil = new FabricPermissionUtil();

    @Override
    public void onInitialize() {
        super.onInitialize();
        PacketUtilImpl.registerPackets();
    }

    @Override
    @Nullable
    public Path getPath(@NotNull String asset) {
        return FabricLoader.getInstance().getModContainer("crowdcontrol").flatMap(container -> container.findPath(asset)).orElse(null);
    }

    @Override
    public InputStream getInputStream(@NotNull String asset) {
        Path path = this.getPath(asset);
        if (path == null) {
            return null;
        }
        try {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            this.getSLF4JLogger().warn("Encountered exception while retrieving asset {}", (Object)asset, (Object)e);
            return null;
        }
    }

    @Override
    @NotNull
    public VersionMetadata getVersionMetadata() {
        return new VersionMetadata(this.server().method_3827(), "Fabric", this.server().getServerModName(), FabricLoader.getInstance().getModContainer("fabricloader").map(container -> container.getMetadata().getVersion().getFriendlyString()).orElse(null));
    }

    @Override
    public void sendToPlayer(@NotNull class_3222 player, @NotNull class_8710 payload) {
        if (!ServerPlayNetworking.canSend((class_3222)player, (class_8710.class_9154)payload.method_56479())) {
            return;
        }
        try {
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        }
        catch (UnsupportedOperationException e) {
            this.getSLF4JLogger().debug("Player {} cannot receive packet {}", (Object)player, (Object)payload);
        }
    }

    @Override
    public FabricServerCommandManager<class_2168> getCommandManager() {
        return this.commandManager;
    }

    @Override
    public PermissionUtil getPermissionUtil() {
        return this.permissionUtil;
    }
}

