/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands.executeorperish;

import dev.qixils.crowdcontrol.plugin.fabric.utils.InventoryUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public final class ConditionFlags
implements Predicate<class_3222> {
    @NotNull
    public static final ConditionFlags DEFAULT = ConditionFlags.builder().build();
    @NotNull
    public static final ConditionFlags OVERWORLD = ConditionFlags.builder().allowedDimensions(Collections.singletonList(class_1937.field_25179)).build();
    @NotNull
    public static final ConditionFlags NETHER = ConditionFlags.builder().allowedDimensions(Collections.singletonList(class_1937.field_25180)).build();
    @NotNull
    public static final ConditionFlags THE_END = ConditionFlags.builder().allowedDimensions(Collections.singletonList(class_1937.field_25181)).build();
    @NotNull
    private final List<class_5321<class_1937>> allowedDimensions;
    @NotNull
    private final Map<class_1792, Integer> requiredItems;

    @Override
    public boolean test(@NotNull class_3222 player) {
        if (!this.allowedDimensions.isEmpty() && !this.allowedDimensions.contains(player.method_51469().method_27983())) {
            return false;
        }
        for (Map.Entry<class_1792, Integer> entry : this.requiredItems.entrySet()) {
            class_1792 item = entry.getKey();
            int required = entry.getValue();
            int count = 0;
            for (class_1799 stack : InventoryUtil.viewAllItems(player.method_31548())) {
                if (stack != null && stack.method_7909() == item && (count += stack.method_7947()) >= required) break;
            }
            if (count >= required) continue;
            return false;
        }
        return true;
    }

    private static List<class_5321<class_1937>> $default$allowedDimensions() {
        return Collections.emptyList();
    }

    private static Map<class_1792, Integer> $default$requiredItems() {
        return Collections.emptyMap();
    }

    ConditionFlags(@NotNull List<class_5321<class_1937>> allowedDimensions, @NotNull Map<class_1792, Integer> requiredItems) {
        if (allowedDimensions == null) {
            throw new NullPointerException("allowedDimensions is marked non-null but is null");
        }
        if (requiredItems == null) {
            throw new NullPointerException("requiredItems is marked non-null but is null");
        }
        this.allowedDimensions = allowedDimensions;
        this.requiredItems = requiredItems;
    }

    public static ConditionFlagsBuilder builder() {
        return new ConditionFlagsBuilder();
    }

    @NotNull
    public List<class_5321<class_1937>> getAllowedDimensions() {
        return this.allowedDimensions;
    }

    @NotNull
    public Map<class_1792, Integer> getRequiredItems() {
        return this.requiredItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConditionFlags)) {
            return false;
        }
        ConditionFlags other = (ConditionFlags)o;
        List<class_5321<class_1937>> this$allowedDimensions = this.getAllowedDimensions();
        List<class_5321<class_1937>> other$allowedDimensions = other.getAllowedDimensions();
        if (this$allowedDimensions == null ? other$allowedDimensions != null : !((Object)this$allowedDimensions).equals(other$allowedDimensions)) {
            return false;
        }
        Map<class_1792, Integer> this$requiredItems = this.getRequiredItems();
        Map<class_1792, Integer> other$requiredItems = other.getRequiredItems();
        return !(this$requiredItems == null ? other$requiredItems != null : !((Object)this$requiredItems).equals(other$requiredItems));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<class_5321<class_1937>> $allowedDimensions = this.getAllowedDimensions();
        result = result * 59 + ($allowedDimensions == null ? 43 : ((Object)$allowedDimensions).hashCode());
        Map<class_1792, Integer> $requiredItems = this.getRequiredItems();
        result = result * 59 + ($requiredItems == null ? 43 : ((Object)$requiredItems).hashCode());
        return result;
    }

    public String toString() {
        return "ConditionFlags(allowedDimensions=" + String.valueOf(this.getAllowedDimensions()) + ", requiredItems=" + String.valueOf(this.getRequiredItems()) + ")";
    }

    public static class ConditionFlagsBuilder {
        private boolean allowedDimensions$set;
        private List<class_5321<class_1937>> allowedDimensions$value;
        private boolean requiredItems$set;
        private Map<class_1792, Integer> requiredItems$value;

        ConditionFlagsBuilder() {
        }

        public ConditionFlagsBuilder allowedDimensions(@NotNull List<class_5321<class_1937>> allowedDimensions) {
            if (allowedDimensions == null) {
                throw new NullPointerException("allowedDimensions is marked non-null but is null");
            }
            this.allowedDimensions$value = allowedDimensions;
            this.allowedDimensions$set = true;
            return this;
        }

        public ConditionFlagsBuilder requiredItems(@NotNull Map<class_1792, Integer> requiredItems) {
            if (requiredItems == null) {
                throw new NullPointerException("requiredItems is marked non-null but is null");
            }
            this.requiredItems$value = requiredItems;
            this.requiredItems$set = true;
            return this;
        }

        public ConditionFlags build() {
            List<class_5321<class_1937>> allowedDimensions$value = this.allowedDimensions$value;
            if (!this.allowedDimensions$set) {
                allowedDimensions$value = ConditionFlags.$default$allowedDimensions();
            }
            Map<class_1792, Integer> requiredItems$value = this.requiredItems$value;
            if (!this.requiredItems$set) {
                requiredItems$value = ConditionFlags.$default$requiredItems();
            }
            return new ConditionFlags(allowedDimensions$value, requiredItems$value);
        }

        public String toString() {
            return "ConditionFlags.ConditionFlagsBuilder(allowedDimensions$value=" + String.valueOf(this.allowedDimensions$value) + ", requiredItems$value=" + String.valueOf(this.requiredItems$value) + ")";
        }
    }
}

