/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.configurate.reactive;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.Nullable;
import dev.qixils.relocated.configurate.reactive.CachedPublisher;
import dev.qixils.relocated.configurate.reactive.Disposable;
import dev.qixils.relocated.configurate.reactive.ExecutePublisher;
import dev.qixils.relocated.configurate.reactive.MappedProcessor;
import dev.qixils.relocated.configurate.reactive.Subscriber;
import dev.qixils.relocated.configurate.reactive.TransactionFailedException;
import dev.qixils.relocated.configurate.util.CheckedFunction;
import dev.qixils.relocated.configurate.util.CheckedSupplier;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;

public interface Publisher<V> {
    public static <V, E extends Exception> Publisher<V> execute(CheckedSupplier<V, E> action) {
        return Publisher.execute(action, ForkJoinPool.commonPool());
    }

    public static <V, E extends Exception> Publisher<V> execute(CheckedSupplier<V, E> action, Executor executor) {
        return new ExecutePublisher<V>(Objects.requireNonNull(action, "action"), Objects.requireNonNull(executor, "executor"));
    }

    public Disposable subscribe(Subscriber<? super V> var1);

    public boolean hasSubscribers();

    default public <R> Publisher<R> map(CheckedFunction<? super V, ? extends R, TransactionFailedException> mapper) {
        return new MappedProcessor<V, R>(mapper, this);
    }

    default public Cached<V> cache() {
        return this.cache(null);
    }

    default public Cached<V> cache(@Nullable V initialValue) {
        return new CachedPublisher<V>(this, initialValue);
    }

    public Executor executor();

    public static interface Cached<V>
    extends Publisher<V> {
        public V get();

        public void submit(V var1);
    }
}

