/*
 * Decompiled with CFR 0.152.
 */
package live.crowdcontrol.cc4j.util;

import java.nio.charset.StandardCharsets;
import java.util.Base64;

public final class TokenUtils {
    private TokenUtils() {
    }

    static String[] splitToken(String token) throws IllegalArgumentException {
        if (token == null) {
            throw new IllegalArgumentException("The token is null.");
        }
        int delimiter = 46;
        int firstPeriodIndex = token.indexOf(delimiter);
        if (firstPeriodIndex == -1) {
            throw TokenUtils.wrongNumberOfParts(0);
        }
        int secondPeriodIndex = token.indexOf(delimiter, firstPeriodIndex + 1);
        if (secondPeriodIndex == -1) {
            throw TokenUtils.wrongNumberOfParts(2);
        }
        if (token.indexOf(delimiter, secondPeriodIndex + 1) != -1) {
            throw TokenUtils.wrongNumberOfParts("> 3");
        }
        String[] parts = new String[]{token.substring(0, firstPeriodIndex), token.substring(firstPeriodIndex + 1, secondPeriodIndex), token.substring(secondPeriodIndex + 1)};
        return parts;
    }

    private static IllegalArgumentException wrongNumberOfParts(Object partCount) {
        return new IllegalArgumentException(String.format("The token was expected to have 3 parts, but got %s.", partCount));
    }

    public static String decodePart(String base64) throws IllegalArgumentException {
        return new String(Base64.getUrlDecoder().decode(base64), StandardCharsets.UTF_8);
    }

    public static String decodePart(String token, int part) throws IllegalArgumentException {
        return TokenUtils.decodePart(TokenUtils.splitToken(token)[part]);
    }

    public static String decodePayload(String token) throws IllegalArgumentException {
        return TokenUtils.decodePart(token, 1);
    }
}

