/*
 * Decompiled with CFR 0.152.
 */
package live.crowdcontrol.cc4j.websocket.payload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import dev.qixils.relocated.annotations.ApiStatus;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.io.IOException;

public class CCName
implements Comparable<CCName> {
    @JsonProperty(value="public")
    @NotNull
    private final String displayName;
    @Nullable
    private final String sort;

    @JsonCreator
    public CCName(@JsonProperty(value="public") @NotNull String displayName, @JsonProperty(value="sort") @Nullable String sort) {
        this.displayName = displayName;
        this.sort = sort;
    }

    public CCName(@NotNull String displayName) {
        this(displayName, null);
    }

    @JsonProperty(value="public")
    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="sort")
    @Nullable
    public String getSortValue() {
        return this.sort;
    }

    @NotNull
    public String computeSortValue() {
        if (this.sort != null) {
            return this.sort;
        }
        return this.displayName;
    }

    @Override
    public int compareTo(@NotNull CCName o) {
        return this.computeSortValue().compareTo(o.computeSortValue());
    }

    @ApiStatus.Internal
    public static class CCNameAdapter
    extends StdDeserializer<CCName> {
        public CCNameAdapter() {
            super(CCName.class);
        }

        @Override
        public CCName deserialize(JsonParser parser, DeserializationContext context) throws IOException, JacksonException {
            String displayName;
            String sortName = null;
            if (parser.isExpectedStartObjectToken()) {
                ObjectCodec codec = parser.getCodec();
                JsonNode node = (JsonNode)codec.readTree(parser);
                displayName = node.get("public").asText();
                JsonNode sortNode = node.get("sort");
                sortName = sortNode != null ? sortNode.asText(null) : null;
            } else {
                displayName = parser.getText();
            }
            return new CCName(displayName, sortName);
        }
    }
}

