/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common;

import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.crowdcontrol.common.util.PermissionWrapper;
import dev.qixils.relocated.annotations.CheckReturnValue;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;

public interface EntityMapper<E> {
    public Plugin<?, ?> getPlugin();

    @NotNull
    default public Audience asAudience(@NotNull E entity) {
        if (entity instanceof Audience) {
            return (Audience)entity;
        }
        throw new UnsupportedOperationException("#asAudience is unsupported");
    }

    @NotNull
    default public Audience asAudience(@NotNull @NotNull Collection<@NotNull E> entities) {
        return (Audience)entities.stream().map(this::asAudience).collect(Audience.toAudience());
    }

    @CheckReturnValue
    @NotNull
    default public Optional<UUID> tryGetUniqueId(@NotNull E entity) {
        return this.asAudience(entity).get(Identity.UUID);
    }

    public boolean hasPermission(@NotNull E var1, @NotNull PermissionWrapper var2);

    default public boolean isAdmin(@NotNull E entity) {
        if (this.hasPermission(entity, Plugin.ADMIN_PERMISSION)) {
            return true;
        }
        Plugin<?, ?> plugin = this.getPlugin();
        Object player = null;
        try {
            player = plugin.asPlayer(entity);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (player == null) {
            return false;
        }
        return plugin.globalEffectsUsableFor(player);
    }

    @CheckReturnValue
    @NotNull
    default public Optional<Locale> getLocale(@NotNull E entity) {
        return this.asAudience(entity).get(Identity.LOCALE);
    }
}

