/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper;

import dev.qixils.relocated.annotations.NotNull;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;

final class EnumDataType<C extends Enum<C>>
implements PersistentDataType<String, C> {
    private final Class<C> complexType;
    private final Function<Optional<C>, C> resolver;

    EnumDataType(Class<C> complexType, Function<Optional<C>, C> resolver) {
        this.complexType = complexType;
        this.resolver = resolver;
    }

    @NotNull
    public Class<String> getPrimitiveType() {
        return String.class;
    }

    @NotNull
    public Class<C> getComplexType() {
        return this.complexType;
    }

    @NotNull
    public String toPrimitive(@NotNull C complex, @NotNull PersistentDataAdapterContext context) {
        return ((Enum)complex).name();
    }

    @NotNull
    public C fromPrimitive(@NotNull String primitive, @NotNull PersistentDataAdapterContext context) {
        return (C)((Enum)this.resolver.apply(Arrays.stream((Enum[])this.complexType.getEnumConstants()).filter(c -> c.name().equals(primitive)).findAny()));
    }
}

