/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper;

import dev.qixils.crowdcontrol.common.SoftLockObserver;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderDragonPart;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;

public class SoftLockResolver
extends SoftLockObserver<Player>
implements Listener {
    private static final Set<Material> DANGEROUS_BLOCKS = EnumSet.of(Material.LAVA, Material.WITHER_ROSE, Material.FIRE);

    protected SoftLockResolver(PaperCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void onSoftLock(@NotNull Player player) {
        Location location = player.getLocation();
        for (Entity entity : location.getNearbyEntities((double)this.getSearchH(), (double)this.getSearchV(), (double)this.getSearchH())) {
            if (entity instanceof Monster || entity instanceof EnderDragon) {
                entity.remove();
                continue;
            }
            if (!(entity instanceof EnderDragonPart)) continue;
            EnderDragonPart enderDragonPart = (EnderDragonPart)entity;
            enderDragonPart.getParent().remove();
            enderDragonPart.remove();
        }
        for (int x = -this.getSearchH(); x <= this.getSearchH(); ++x) {
            for (int y = -this.getSearchV(); y <= this.getSearchV(); ++y) {
                for (int z = -this.getSearchH(); z <= this.getSearchH(); ++z) {
                    Location blockLocation = location.clone().add((double)x, (double)y, (double)z);
                    Block block = blockLocation.getBlock();
                    Material material = block.getType();
                    if (!DANGEROUS_BLOCKS.contains(material)) continue;
                    block.setType(Material.AIR);
                }
            }
        }
        player.sendMessage(ALERT);
    }

    @EventHandler
    public void onDeathEvent(PlayerDeathEvent event) {
        if (event.getEntity().getKiller() != null) {
            return;
        }
        this.onDeath(event.getEntity());
    }
}

