/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.TriState;
import dev.qixils.crowdcontrol.exceptions.ExceptionUtil;
import dev.qixils.crowdcontrol.plugin.paper.FeatureElementCommand;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.List;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.IUserRecord;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.World;
import org.bukkit.entity.Enemy;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public interface EntityCommand
extends FeatureElementCommand {
    @NotNull
    public EntityType getEntityType();

    @NotNull
    default public Class<? extends Entity> getEntityClass() {
        return ExceptionUtil.validateNotNull(this.getEntityType().getEntityClass(), "entityClass");
    }

    @Override
    default public boolean isFeatureEnabled(@NotNull World world) {
        return this.getEntityType().isEnabledByFeature(world);
    }

    default public boolean isMonster() {
        return Enemy.class.isAssignableFrom(this.getEntityClass());
    }

    default public boolean levelIsPeaceful(@NotNull World level) {
        return level.getDifficulty() == Difficulty.PEACEFUL;
    }

    default public boolean serverIsPeaceful() {
        return Bukkit.getWorlds().stream().allMatch(this::levelIsPeaceful);
    }

    @Override
    default public TriState isSelectable(@NotNull IUserRecord user, @NotNull List<Player> potentialPlayers) {
        if (!this.isMonster()) {
            return TriState.UNKNOWN;
        }
        if (!this.serverIsPeaceful()) {
            return TriState.TRUE;
        }
        return TriState.FALSE;
    }

    @Nullable
    default public CCEffectResponse tryExecute(@NotNull @NotNull List<@NotNull Player> players, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        CCInstantEffectResponse error = null;
        for (Player player : players) {
            World world = player.getWorld();
            if (this.isMonster() && this.levelIsPeaceful(world)) {
                error = new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Hostile mobs cannot be spawned while on Peaceful difficulty");
                continue;
            }
            if (this.getEntityType() == EntityType.ENDER_DRAGON && world.getEnvironment() == World.Environment.THE_END) {
                error = new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Ender Dragons are very sensitive cannot be spawned in or removed from The End, sorry!");
                continue;
            }
            if (!this.getEntityType().isEnabledByFeature(world)) {
                error = new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Mob is not available in this version of Minecraft");
                continue;
            }
            return null;
        }
        return error;
    }
}

