/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.components.MovementStatusType;
import dev.qixils.crowdcontrol.common.components.MovementStatusValue;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.paper.PaperCommand;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.commands.MovementStatusCommand;
import dev.qixils.relocated.annotations.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.CrowdControl;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class FreezeCommand
extends PaperCommand
implements CCTimedEffect {
    public static final Map<UUID, List<FreezeData>> DATA = new HashMap<UUID, List<FreezeData>>();
    private static final Map<UUID, Map<UUID, FreezeData>> TIMED_EFFECTS = new HashMap<UUID, Map<UUID, FreezeData>>();
    private final String effectName;
    private final String effectGroup;
    private final List<String> effectGroups;
    private final LocationModifier modifier;
    private final MovementStatusType freezeType;
    private final MovementStatusValue freezeValue;

    public FreezeCommand(PaperCrowdControlPlugin plugin, String effectName, String effectGroup, LocationModifier modifier, MovementStatusType freezeType, MovementStatusValue freezeValue) {
        super(plugin);
        this.effectName = effectName;
        this.effectGroup = effectGroup;
        this.effectGroups = Collections.singletonList(effectGroup);
        this.modifier = modifier;
        this.freezeType = freezeType;
        this.freezeValue = freezeValue;
    }

    public FreezeCommand(PaperCrowdControlPlugin plugin, String effectName, LocationModifier modifier, MovementStatusType freezeType, MovementStatusValue freezeValue) {
        this(plugin, effectName, effectName, modifier, freezeType, freezeValue);
    }

    public FreezeCommand(PaperCrowdControlPlugin plugin, String effectName, String effectGroup, LocationModifier modifier, MovementStatusType freezeType) {
        this(plugin, effectName, effectGroup, modifier, freezeType, MovementStatusValue.DENIED);
    }

    public FreezeCommand(PaperCrowdControlPlugin plugin, String effectName, LocationModifier modifier, MovementStatusType freezeType) {
        this(plugin, effectName, effectName, modifier, freezeType);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull Player>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            HashMap locations = new HashMap();
            players.forEach(player -> {
                UUID uuid = player.getUniqueId();
                FreezeData data = new FreezeData(this.modifier, player.getLocation());
                locations.put(uuid, data);
                DATA.computeIfAbsent(uuid, $2 -> new ArrayList()).add(data);
                MovementStatusCommand.setValue(this.plugin, player, this.freezeType, this.freezeValue);
            });
            TIMED_EFFECTS.put(request.getRequestId(), locations);
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }));
    }

    @Override
    public void onEnd(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        Map<UUID, FreezeData> locations = TIMED_EFFECTS.remove(request.getRequestId());
        if (locations == null) {
            return;
        }
        locations.forEach((uuid, data) -> {
            DATA.get(uuid).remove(data);
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) {
                return;
            }
            MovementStatusCommand.setValue(this.plugin, player, this.freezeType, MovementStatusValue.ALLOWED);
        });
    }

    private static Location withRotation(Location posSource, float yaw, float pitch) {
        return new Location(posSource.getWorld(), posSource.x(), posSource.y(), posSource.z(), yaw, pitch);
    }

    private static Location withRotationOf(Location posSource, Location rotSource) {
        return FreezeCommand.withRotation(posSource, rotSource.getYaw(), rotSource.getPitch());
    }

    private static Location withPositionOf(Location rotSource, Location posSource) {
        return FreezeCommand.withRotationOf(posSource, rotSource);
    }

    public static FreezeCommand feet(PaperCrowdControlPlugin plugin) {
        return new FreezeCommand(plugin, "freeze", "walk", FreezeCommand::withPositionOf, MovementStatusType.WALK);
    }

    public static FreezeCommand camera(PaperCrowdControlPlugin plugin) {
        return new FreezeCommand(plugin, "camera_lock", "look", FreezeCommand::withRotationOf, MovementStatusType.LOOK);
    }

    public static FreezeCommand skyCamera(PaperCrowdControlPlugin plugin) {
        return new FreezeCommand(plugin, "camera_lock_to_sky", "look", (cur, prev) -> FreezeCommand.withRotation(cur, cur.getYaw(), -90.0f), MovementStatusType.LOOK, MovementStatusValue.PARTIAL);
    }

    public static FreezeCommand groundCamera(PaperCrowdControlPlugin plugin) {
        return new FreezeCommand(plugin, "camera_lock_to_ground", "look", (cur, prev) -> FreezeCommand.withRotation(cur, cur.getYaw(), 90.0f), MovementStatusType.LOOK, MovementStatusValue.PARTIAL);
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    public String getEffectGroup() {
        return this.effectGroup;
    }

    @Override
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }

    public LocationModifier getModifier() {
        return this.modifier;
    }

    public MovementStatusType getFreezeType() {
        return this.freezeType;
    }

    public MovementStatusValue getFreezeValue() {
        return this.freezeValue;
    }

    @FunctionalInterface
    public static interface LocationModifier
    extends BiFunction<Location, Location, Location> {
        @Override
        public Location apply(@NotNull Location var1, @NotNull Location var2);
    }

    public static final class FreezeData {
        public final LocationModifier modifier;
        public Location previousLocation;

        public Location getDestination(Location currentLocation) {
            return this.modifier.apply(currentLocation, this.previousLocation);
        }

        public FreezeData(LocationModifier modifier, Location previousLocation) {
            this.modifier = modifier;
            this.previousLocation = previousLocation;
        }
    }

    public static final class Manager
    implements Listener {
        private final PaperCrowdControlPlugin plugin;

        public Manager(PaperCrowdControlPlugin plugin) {
            this.plugin = plugin;
            Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)plugin.getPaperPlugin(), $ -> {
                for (Map.Entry<UUID, List<FreezeData>> entry : DATA.entrySet()) {
                    UUID uuid = entry.getKey();
                    Player player = Bukkit.getPlayer((UUID)uuid);
                    if (player == null) continue;
                    player.getScheduler().run((Plugin)plugin.getPaperPlugin(), $$ -> {
                        Location cur = player.getLocation();
                        Location dest = cur.clone();
                        for (FreezeData data : (List)entry.getValue()) {
                            dest = data.getDestination(dest);
                        }
                        if (!Objects.equals(cur.getWorld(), dest.getWorld())) {
                            return;
                        }
                        if (!dest.equals((Object)cur)) {
                            player.teleportAsync(dest);
                        }
                        for (FreezeData data : (List)entry.getValue()) {
                            data.previousLocation = dest;
                        }
                    }, null);
                }
            }, 1L, 1L);
        }

        @EventHandler
        public void onDeath(PlayerDeathEvent death) {
            CrowdControl cc = this.plugin.getCrowdControl();
            if (cc == null) {
                return;
            }
            UUID uuid = death.getPlayer().getUniqueId();
            Set<UUID> requestIds = TIMED_EFFECTS.entrySet().stream().filter(entry -> ((Map)entry.getValue()).containsKey(uuid)).map(Map.Entry::getKey).collect(Collectors.toSet());
            requestIds.forEach(cc::cancelByRequestId);
        }

        @EventHandler
        public void onJoin(PlayerJoinEvent event) {
            for (MovementStatusType type : MovementStatusType.values()) {
                MovementStatusCommand.setValue(this.plugin, event.getPlayer(), type, MovementStatusValue.ALLOWED);
            }
        }
    }
}

