/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.RandomUtil;
import dev.qixils.crowdcontrol.common.util.Weighted;
import dev.qixils.crowdcontrol.common.util.sound.Sounds;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.RegionalCommandSync;
import dev.qixils.relocated.annotations.Contract;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.translation.GlobalTranslator;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.plugin.Plugin;

public class LootboxCommand
extends RegionalCommandSync {
    private static final List<Material> ITEMS = Registry.MATERIAL.stream().filter(mat -> mat.isItem() && !mat.isAir()).toList();
    private static final Set<Material> GOOD_ITEMS = ITEMS.stream().filter(material -> material.getMaxDurability() > 1 || material == Material.GOLDEN_APPLE || material == Material.ENCHANTED_GOLDEN_APPLE || material == Material.DIAMOND_BLOCK || material == Material.NETHERITE_BLOCK || material == Material.IRON_BLOCK || material == Material.GOLD_BLOCK).collect(Collectors.toUnmodifiableSet());
    private static final List<Attribute> ATTRIBUTES = Arrays.asList(Attribute.MAX_HEALTH, Attribute.KNOCKBACK_RESISTANCE, Attribute.MOVEMENT_SPEED, Attribute.ATTACK_DAMAGE, Attribute.ARMOR, Attribute.ARMOR_TOUGHNESS, Attribute.ATTACK_KNOCKBACK, Attribute.ATTACK_SPEED);
    private static final Map<UUID, Inventory> OPEN_LOOTBOXES = new HashMap<UUID, Inventory>();
    private final String effectName;
    private final int luck;

    public LootboxCommand(PaperCrowdControlPlugin plugin, int luck) {
        super(plugin);
        this.luck = luck;
        StringBuilder effectName = new StringBuilder("lootbox");
        if (luck > 0) {
            effectName.append('_').append(luck);
        }
        this.effectName = effectName.toString();
    }

    private static boolean isLootboxOpen(@NotNull UUID uuid) {
        if (!OPEN_LOOTBOXES.containsKey(uuid)) {
            return false;
        }
        Inventory inv = OPEN_LOOTBOXES.get(uuid);
        if (inv.isEmpty() || inv.getViewers().isEmpty()) {
            OPEN_LOOTBOXES.remove(uuid);
            return false;
        }
        return true;
    }

    private static boolean isGoodItem(@Nullable Material item) {
        return item != null && GOOD_ITEMS.contains(item);
    }

    public static ItemStack createRandomItem(int luck, @Nullable RegistryAccess registryAccess) {
        ArrayList<Material> items = new ArrayList<Material>(ITEMS);
        items.removeIf(item -> !PaperCrowdControlPlugin.isFeatureEnabled(item));
        Collections.shuffle(items, random);
        Material item2 = null;
        for (int i = 0; i <= luck * 5; ++i) {
            Material oldItem = item2;
            item2 = (Material)items.get(i);
            if (LootboxCommand.isGoodItem(item2) && !LootboxCommand.isGoodItem(oldItem)) break;
        }
        assert (item2 != null);
        int quantity = 1;
        if (item2.getMaxStackSize() > 1) {
            for (int i = 0; i <= luck; ++i) {
                quantity = Math.max(quantity, RandomUtil.nextInclusiveInt(1, item2.getMaxStackSize()));
            }
        }
        ItemStack itemStack = new ItemStack(item2, quantity);
        LootboxCommand.randomlyModifyItem(itemStack, luck, registryAccess);
        return itemStack;
    }

    @Contract(mutates="param1")
    public static void randomlyModifyItem(ItemStack itemStack, int luck, @Nullable RegistryAccess registryAccess) {
        int i;
        if (registryAccess == null) {
            registryAccess = RegistryAccess.registryAccess();
        }
        Material item = itemStack.getType();
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (random.nextDouble() >= 0.95 - (double)luck * 0.1) {
            itemMeta.setUnbreakable(true);
        }
        if (random.nextInt(4) == 0 && itemMeta instanceof ArmorMeta) {
            ArmorMeta armorMeta = (ArmorMeta)itemMeta;
            armorMeta.setTrim(new ArmorTrim((TrimMaterial)RandomUtil.randomElementFrom(registryAccess.getRegistry(RegistryKey.TRIM_MATERIAL)), (TrimPattern)RandomUtil.randomElementFrom(registryAccess.getRegistry(RegistryKey.TRIM_PATTERN))));
        }
        int enchantments = 0;
        for (int i2 = 0; i2 <= luck; ++i2) {
            enchantments = Math.max(enchantments, ((CommandConstants.EnchantmentWeights)RandomUtil.weightedRandom((Weighted[])CommandConstants.EnchantmentWeights.values(), (int)CommandConstants.EnchantmentWeights.TOTAL_WEIGHTS)).getLevel());
        }
        List enchantmentList = registryAccess.getRegistry(RegistryKey.ENCHANTMENT).stream().filter(enchantment -> enchantment.canEnchantItem(itemStack)).collect(Collectors.toList());
        if (random.nextDouble() >= 0.8 - (double)luck * 0.2) {
            enchantmentList.removeIf(Enchantment::isCursed);
        }
        if (enchantments > 0 && !enchantmentList.isEmpty()) {
            Collections.shuffle(enchantmentList, random);
            ArrayList<Enchantment> addedEnchantments = new ArrayList<Enchantment>(enchantments);
            for (i = 0; i < enchantmentList.size() && addedEnchantments.size() < enchantments; ++i) {
                Enchantment enchantment2 = (Enchantment)enchantmentList.get(i);
                boolean isVanilla = enchantment2.key().namespace().equals("minecraft");
                if (addedEnchantments.stream().anyMatch(x -> x.conflictsWith(enchantment2) && (!isVanilla || !x.key().namespace().equals("minecraft") || random.nextDouble() >= 0.1 + (double)luck * 0.1))) continue;
                addedEnchantments.add(enchantment2);
                int level = enchantment2.getStartLevel();
                if (enchantment2.getMaxLevel() > level) {
                    for (int j = 0; j <= luck; ++j) {
                        level = Math.max(level, RandomUtil.nextInclusiveInt(enchantment2.getStartLevel(), enchantment2.getMaxLevel()));
                    }
                    if (random.nextDouble() >= 0.5 - (double)luck * 0.07) {
                        level += random.nextInt(4);
                    }
                }
                itemMeta.addEnchant(enchantment2, level, true);
            }
        }
        int attributes = 0;
        for (i = 0; i <= luck; ++i) {
            attributes = Math.max(attributes, ((CommandConstants.AttributeWeights)RandomUtil.weightedRandom((Weighted[])CommandConstants.AttributeWeights.values(), (int)CommandConstants.AttributeWeights.TOTAL_WEIGHTS)).getLevel());
        }
        if (attributes > 0 && item.getMaxDurability() <= 1) {
            EquipmentSlot target = item.getEquipmentSlot();
            ArrayList<Attribute> attributeList = new ArrayList<Attribute>(ATTRIBUTES);
            Collections.shuffle(attributeList, random);
            for (int i3 = 0; i3 < attributeList.size() && i3 < attributes; ++i3) {
                Attribute attribute = (Attribute)attributeList.get(i3);
                String name = "lootbox_" + attribute.getKey().getKey();
                double amount = 0.0;
                for (int j = 0; j <= luck; ++j) {
                    amount = Math.max(amount, random.nextDouble() * 2.0 - 1.0);
                }
                itemMeta.addAttributeModifier(attribute, LootboxCommand.createModifier(name, amount, target));
                if (target != EquipmentSlot.HAND) continue;
                itemMeta.addAttributeModifier(attribute, LootboxCommand.createModifier(name + "_offhand", amount, EquipmentSlot.OFF_HAND));
            }
        }
        itemStack.setItemMeta(itemMeta);
    }

    @NotNull
    private static AttributeModifier createModifier(@NotNull String name, double amount, @NotNull EquipmentSlot slot) {
        return new AttributeModifier(UUID.randomUUID(), name, amount, AttributeModifier.Operation.MULTIPLY_SCALAR_1, slot);
    }

    @Override
    @NotNull
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Player already has a lootbox open");
    }

    @Override
    protected boolean executeRegionallySync(@NotNull Player player, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        if (LootboxCommand.isLootboxOpen(player.getUniqueId())) {
            return false;
        }
        Inventory lootbox = Bukkit.createInventory(null, (int)27, (Component)CommandConstants.buildLootboxTitle(this.plugin, request));
        for (int slot : CommandConstants.lootboxItemSlots(this.luck)) {
            ItemStack randomItem = LootboxCommand.createRandomItem(this.luck, null);
            ItemMeta itemMeta = randomItem.getItemMeta();
            itemMeta.lore(Collections.singletonList(GlobalTranslator.render((Component)CommandConstants.buildLootboxLore(this.plugin, request), (Locale)player.locale())));
            randomItem.setItemMeta(itemMeta);
            lootbox.setItem(slot, randomItem);
        }
        InventoryView view = player.openInventory(lootbox);
        if (view == null) {
            return false;
        }
        player.playSound(Sounds.LOOTBOX_CHIME.get(this.luck), Sound.Emitter.self());
        OPEN_LOOTBOXES.put(player.getUniqueId(), lootbox);
        return true;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    public int getLuck() {
        return this.luck;
    }

    public static final class Manager
    implements Listener {
        private final PaperCrowdControlPlugin plugin;

        @EventHandler
        public void onCloseInventory(InventoryCloseEvent event) {
            HumanEntity player = event.getPlayer();
            UUID uuid = player.getUniqueId();
            if (event.getReason() != InventoryCloseEvent.Reason.PLAYER) {
                OPEN_LOOTBOXES.remove(uuid);
                return;
            }
            if (!LootboxCommand.isLootboxOpen(uuid)) {
                return;
            }
            Inventory lootbox = OPEN_LOOTBOXES.get(uuid);
            player.getScheduler().run((Plugin)this.plugin.getPaperPlugin(), $ -> player.openInventory(lootbox), null);
        }

        public Manager(PaperCrowdControlPlugin plugin) {
            this.plugin = plugin;
        }
    }
}

