/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.command.impl.Shader;
import dev.qixils.crowdcontrol.common.packets.ShaderPacketS2C;
import dev.qixils.crowdcontrol.common.util.SemVer;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.paper.PaperCommand;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.utils.PaperUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class ShaderCommand
extends PaperCommand
implements CCTimedEffect {
    @NotNull
    private static final Set<UUID> ACTIVE_SHADERS = new HashSet<UUID>();
    @NotNull
    private final String effectName;
    @NotNull
    private final String shader;
    @NotNull
    private final SemVer minimumModVersion;
    @NotNull
    private final Duration defaultDuration = Duration.ofSeconds(30L);
    @NotNull
    private final Map<UUID, List<UUID>> idMap = new HashMap<UUID, List<UUID>>();

    public ShaderCommand(@NotNull PaperCrowdControlPlugin plugin, @NotNull Shader shader) {
        super(plugin);
        this.effectName = shader.getEffectId();
        this.minimumModVersion = shader.addedIn();
        this.shader = shader.getShaderId();
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull Player>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            players.removeIf(player -> ACTIVE_SHADERS.contains(player.getUniqueId()));
            if (players.isEmpty()) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "All players already have an active screen effect");
            }
            this.idMap.put(request.getRequestId(), players.stream().map(OfflinePlayer::getUniqueId).toList());
            Duration duration = Duration.ofMillis(request.getEffect().getDurationMillis());
            ShaderPacketS2C packet = new ShaderPacketS2C(this.shader, duration);
            for (Player player2 : players) {
                ACTIVE_SHADERS.add(player2.getUniqueId());
                this.plugin.getPluginChannel().sendMessage(player2, packet);
            }
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, duration.toMillis());
        }));
    }

    @Override
    public void onEnd(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        PaperUtil.toPlayers(this.idMap.remove(request.getRequestId())).forEach(player -> ACTIVE_SHADERS.remove(player.getUniqueId()));
    }

    @Override
    @NotNull
    public String getEffectName() {
        return this.effectName;
    }

    @NotNull
    public String getShader() {
        return this.shader;
    }

    @Override
    @NotNull
    public SemVer getMinimumModVersion() {
        return this.minimumModVersion;
    }

    @NotNull
    public Duration getDefaultDuration() {
        return this.defaultDuration;
    }

    @NotNull
    public Map<UUID, List<UUID>> getIdMap() {
        return this.idMap;
    }
}

