/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.commands.SummonEntityCommand;
import dev.qixils.crowdcontrol.plugin.paper.utils.AttributeUtil;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import net.kyori.adventure.text.Component;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Spider;

public class SmallAntCommand
extends SummonEntityCommand {
    private final String effectName = "entity_small_ant";
    private final Component displayName = this.getDefaultDisplayName();

    public SmallAntCommand(PaperCrowdControlPlugin plugin) {
        super(plugin, EntityType.SPIDER);
    }

    @Override
    protected Entity spawnEntity(@Nullable Component viewer, @NotNull Player player) {
        Spider spider = (Spider)super.spawnEntity(viewer, player);
        if (spider == null) {
            return null;
        }
        AttributeUtil.addModifier((Attributable)spider, Attribute.SCALE, CommandConstants.ANT_SCALE_MODIFIER_UUID, "ant-scale-cc", -0.6, AttributeModifier.Operation.ADD_SCALAR, true);
        AttributeUtil.addModifier((Attributable)spider, Attribute.MOVEMENT_SPEED, CommandConstants.ANT_SPEED_MODIFIER_UUID, "ant-speed-cc", 0.4, AttributeModifier.Operation.ADD_SCALAR, true);
        AttributeUtil.addModifier((Attributable)spider, Attribute.STEP_HEIGHT, CommandConstants.ANT_STEP_MODIFIER_UUID, "ant-step-cc", 1.0, AttributeModifier.Operation.ADD_SCALAR, true);
        AttributeUtil.addModifier((Attributable)spider, Attribute.ENTITY_INTERACTION_RANGE, CommandConstants.ANT_RANGE_MODIFIER_UUID, "ant-range-cc", -0.5, AttributeModifier.Operation.ADD_SCALAR, true);
        return spider;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    public Component getDisplayName() {
        return this.displayName;
    }
}

