/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.util.RandomUtil;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.RegionalCommand;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;
import org.joml.Math;

public class TeleportCommand
extends RegionalCommand {
    private final String effectName = "chorus_fruit";
    private final List<String> effectGroups = List.of("walk", "look");

    public TeleportCommand(PaperCrowdControlPlugin plugin) {
        super(plugin);
    }

    private static double nextDoubleOffset() {
        double value = RandomUtil.RNG.nextDouble(3.0, 16.0);
        if (RandomUtil.RNG.nextBoolean()) {
            value = -value;
        }
        return value;
    }

    private static int nextIntOffset() {
        int value = RandomUtil.RNG.nextInt(3, 16);
        if (RandomUtil.RNG.nextBoolean()) {
            value = -value;
        }
        return value;
    }

    @Override
    @Nullable
    protected CCEffectResponse precheck(@NotNull @NotNull List<@NotNull Player> players, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        if (this.isArrayActive(ccPlayer)) {
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Cannot teleport while frozen");
        }
        return null;
    }

    @Override
    @NotNull
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No teleportation destinations were available");
    }

    @Override
    protected CompletableFuture<Boolean> executeRegionallyAsync(@NotNull Player player, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return CompletableFuture.supplyAsync(() -> {
            Location loc = player.getLocation();
            World level = loc.getWorld();
            double x = loc.getX();
            double y = loc.getY();
            double z = loc.getZ();
            for (int i = 0; i < 16; ++i) {
                double destZ;
                double destY;
                double destX = x + TeleportCommand.nextDoubleOffset();
                if (!this.randomTeleport(player, destX, destY = Math.clamp((double)(y + (double)TeleportCommand.nextIntOffset()), (double)level.getMinHeight(), (double)(level.getMinHeight() + level.getLogicalHeight() - 1)), destZ = z + TeleportCommand.nextDoubleOffset())) continue;
                level.playSound(loc, Sound.ITEM_CHORUS_FRUIT_TELEPORT, SoundCategory.PLAYERS, 1.0f, 1.0f);
                player.playSound((Entity)player, Sound.ITEM_CHORUS_FRUIT_TELEPORT, 1.0f, 1.0f);
                return true;
            }
            return false;
        }, this.getPlugin().getSyncExecutor());
    }

    public boolean randomTeleport(Player player, double destX, double destY, double destZ) {
        Location loc = player.getLocation();
        Location dest = loc.clone().set(destX, destY, destZ);
        int chunkX = (int)Math.floor((double)destX) >> 4;
        int chunkZ = (int)Math.floor((double)destZ) >> 4;
        World world = player.getWorld();
        if (!world.isChunkLoaded(chunkX, chunkZ)) {
            return false;
        }
        while (dest.getY() > (double)world.getMinHeight()) {
            Block block = world.getBlockAt(dest.clone().subtract(0.0, 1.0, 0.0));
            if (block.isCollidable()) {
                player.teleport(dest);
                BoundingBox bb = player.getBoundingBox();
                if (!world.hasCollisionsIn(bb) && !this.containsAnyLiquid(world, bb)) {
                    player.playEffect(EntityEffect.TELEPORT_ENDER);
                    return true;
                }
                player.teleport(loc);
            }
            dest.subtract(0.0, 1.0, 0.0);
        }
        return false;
    }

    public boolean containsAnyLiquid(World world, BoundingBox box) {
        int minX = (int)Math.floor((double)box.getMinX());
        int maxX = (int)Math.ceil((double)box.getMaxX());
        int minY = (int)Math.floor((double)box.getMinY());
        int maxY = (int)Math.ceil((double)box.getMaxY());
        int minZ = (int)Math.floor((double)box.getMinZ());
        int maxZ = (int)Math.ceil((double)box.getMaxZ());
        Location location = new Location(world, 0.0, 0.0, 0.0);
        for (int o = minX; o < maxX; ++o) {
            for (int p = minY; p < maxY; ++p) {
                for (int q = minZ; q < maxZ; ++q) {
                    Block block = world.getBlockAt(location.set((double)o, (double)p, (double)q));
                    if (!block.isLiquid()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }
}

