/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.Global;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.paper.PaperCommand;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

@Global
public class TickRateCommand
extends PaperCommand
implements CCTimedEffect {
    private static final float RATE = 20.0f;
    private final String effectName;
    private final float multiplier;
    private final String effectGroup = "tick_rate";
    private final List<String> effectGroups = Collections.singletonList("tick_rate");

    private TickRateCommand(PaperCrowdControlPlugin plugin, String effectName, float multiplier) {
        super(plugin);
        this.effectName = effectName;
        this.multiplier = multiplier;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull Player>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            playerSupplier.get();
            this.onResume(request, ccPlayer);
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }));
    }

    private void set(float value) {
        Bukkit.getServerTickManager().setTickRate(value);
    }

    @Override
    public void onPause(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        this.set(20.0f);
    }

    @Override
    public void onResume(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        this.set(20.0f * this.multiplier);
    }

    @Override
    public void onEnd(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        this.onPause(request, source);
    }

    public static TickRateCommand doubleRate(PaperCrowdControlPlugin plugin) {
        return new TickRateCommand(plugin, "tick_double", 2.0f);
    }

    public static TickRateCommand halfRate(PaperCrowdControlPlugin plugin) {
        return new TickRateCommand(plugin, "tick_halve", 0.5f);
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public String getEffectGroup() {
        return this.effectGroup;
    }

    @Override
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }
}

