/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.utils;

import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.crowdcontrol.common.util.PermissionWrapper;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.util.TriState;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public class PaperUtil {
    public static final Permission ADMIN_PERMISSION = PaperUtil.toPaper(Plugin.ADMIN_PERMISSION);

    private PaperUtil() {
    }

    public static PermissionDefault toPaper(PermissionWrapper.DefaultPermission defaultPermission) {
        return switch (defaultPermission) {
            default -> throw new MatchException(null, null);
            case PermissionWrapper.DefaultPermission.ALL -> PermissionDefault.TRUE;
            case PermissionWrapper.DefaultPermission.OP -> PermissionDefault.OP;
            case PermissionWrapper.DefaultPermission.NONE -> PermissionDefault.FALSE;
        };
    }

    public static Permission toPaper(PermissionWrapper permission) {
        return new Permission(permission.getNode(), permission.getDescription(), PaperUtil.toPaper(permission.getDefaultPermission()));
    }

    @NotNull
    public static NamespacedKey toPaper(@NotNull Key key) {
        if (key instanceof NamespacedKey) {
            NamespacedKey nkKey = (NamespacedKey)key;
            return nkKey;
        }
        return new NamespacedKey(key.namespace(), key.value());
    }

    public static boolean hasPermission(Permissible permissible, Permission permission) {
        return switch (permissible.permissionValue(permission)) {
            case TriState.TRUE -> true;
            case TriState.FALSE -> false;
            default -> permission.getDefault().getValue(permissible.isOp());
        };
    }

    public static List<Player> toPlayers(@Nullable List<UUID> uuids) {
        if (uuids == null) {
            return Collections.emptyList();
        }
        return uuids.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).toList();
    }
}

