/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.cloud.bukkit;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.NonNull;
import dev.qixils.relocated.cloud.bukkit.BukkitCommandManager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.server.PluginDisableEvent;

final class CloudBukkitListener<C>
implements Listener {
    private final BukkitCommandManager<C> bukkitCommandManager;

    CloudBukkitListener(@NonNull BukkitCommandManager<C> bukkitCommandManager) {
        this.bukkitCommandManager = bukkitCommandManager;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    void onPlayerLogin(@NonNull PlayerLoginEvent event) {
        this.bukkitCommandManager.lockIfBrigadierCapable();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void onPluginDisable(@NonNull PluginDisableEvent event) {
        if (event.getPlugin().equals((Object)this.bukkitCommandManager.owningPlugin())) {
            this.bukkitCommandManager.rootCommands().forEach(this.bukkitCommandManager::deleteRootCommand);
        }
    }
}

