/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.cloud.minecraft.extras.caption;

import dev.qixils.relocated.adventure.minimessage.MiniMessage;
import dev.qixils.relocated.adventure.minimessage.tag.resolver.TagResolver;
import dev.qixils.relocated.checkerframework.checker.nullness.qual.NonNull;
import dev.qixils.relocated.cloud.caption.Caption;
import dev.qixils.relocated.cloud.caption.CaptionFormatter;
import dev.qixils.relocated.cloud.caption.CaptionVariable;
import dev.qixils.relocated.cloud.minecraft.extras.caption.MiniMessageComponentCaptionFormatter;
import dev.qixils.relocated.cloud.minecraft.extras.caption.PatternReplacingComponentCaptionFormatter;
import dev.qixils.relocated.cloud.minecraft.extras.caption.RichVariable;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0")
public interface ComponentCaptionFormatter<C>
extends CaptionFormatter<C, Component> {
    public static <C> @NonNull ComponentCaptionFormatter<C> miniMessage() {
        return ComponentCaptionFormatter.miniMessage(MiniMessage.miniMessage());
    }

    public static <C> @NonNull ComponentCaptionFormatter<C> miniMessage(@NonNull MiniMessage miniMessage) {
        return ComponentCaptionFormatter.miniMessage(miniMessage, new TagResolver[0]);
    }

    public static <C> @NonNull ComponentCaptionFormatter<C> miniMessage(@NonNull MiniMessage miniMessage, TagResolver ... resolvers) {
        return new MiniMessageComponentCaptionFormatter(miniMessage, Arrays.asList(resolvers));
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static <C> @NonNull ComponentCaptionFormatter<C> translatable() {
        return new ComponentCaptionFormatter<C>(){

            @Override
            public @NonNull Component formatCaption(@NonNull Caption captionKey, @NonNull C recipient, @NonNull String caption, @NonNull List<@NonNull CaptionVariable> variables) {
                return Component.translatable((String)captionKey.key(), variables.stream().map(variable -> {
                    if (variable instanceof RichVariable) {
                        return (RichVariable)variable;
                    }
                    return Component.text((String)variable.value());
                }).collect(Collectors.toList()));
            }
        };
    }

    public static <C> @NonNull ComponentCaptionFormatter<C> patternReplacing(@NonNull Pattern pattern) {
        return new PatternReplacingComponentCaptionFormatter(pattern);
    }

    public static <C> @NonNull ComponentCaptionFormatter<C> placeholderReplacing() {
        return new PatternReplacingComponentCaptionFormatter(CaptionFormatter.placeholderPattern());
    }
}

