/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.cloud.parser.standard;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.NonNull;
import dev.qixils.relocated.cloud.caption.CaptionVariable;
import dev.qixils.relocated.cloud.caption.StandardCaptionKeys;
import dev.qixils.relocated.cloud.component.CommandComponent;
import dev.qixils.relocated.cloud.context.CommandContext;
import dev.qixils.relocated.cloud.context.CommandInput;
import dev.qixils.relocated.cloud.exception.parsing.ParserException;
import dev.qixils.relocated.cloud.parser.ArgumentParseResult;
import dev.qixils.relocated.cloud.parser.ArgumentParser;
import dev.qixils.relocated.cloud.parser.ParserDescriptor;
import java.util.Objects;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class CharacterParser<C>
implements ArgumentParser<C, Character> {
    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Character> characterParser() {
        return ParserDescriptor.of(new CharacterParser<C>(), Character.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull CommandComponent.Builder<C, Character> characterComponent() {
        return CommandComponent.builder().parser(CharacterParser.characterParser());
    }

    @Override
    public @NonNull ArgumentParseResult<Character> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        if (commandInput.peekString().length() != 1) {
            return ArgumentParseResult.failure(new CharParseException(commandInput.peekString(), commandContext));
        }
        return ArgumentParseResult.success(Character.valueOf(commandInput.read()));
    }

    @API(status=API.Status.STABLE)
    public static final class CharParseException
    extends ParserException {
        private final String input;

        public CharParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(CharacterParser.class, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_CHAR, CaptionVariable.of("input", input));
            this.input = input;
        }

        public @NonNull String input() {
            return this.input;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CharParseException that = (CharParseException)o;
            return this.input.equals(that.input);
        }

        public int hashCode() {
            return Objects.hash(this.input);
        }
    }
}

