/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.cloud.parser.standard;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.NonNull;
import dev.qixils.relocated.cloud.component.CommandComponent;
import dev.qixils.relocated.cloud.context.CommandContext;
import dev.qixils.relocated.cloud.context.CommandInput;
import dev.qixils.relocated.cloud.exception.parsing.NumberParseException;
import dev.qixils.relocated.cloud.parser.ArgumentParseResult;
import dev.qixils.relocated.cloud.parser.ParserDescriptor;
import dev.qixils.relocated.cloud.parser.standard.IntegerParser;
import dev.qixils.relocated.cloud.parser.standard.NumberParser;
import dev.qixils.relocated.cloud.suggestion.BlockingSuggestionProvider;
import dev.qixils.relocated.cloud.type.range.Range;
import dev.qixils.relocated.cloud.type.range.ShortRange;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class ShortParser<C>
extends NumberParser<C, Short, ShortRange>
implements BlockingSuggestionProvider.Strings<C> {
    @API(status=API.Status.STABLE)
    public static final short DEFAULT_MINIMUM = Short.MIN_VALUE;
    @API(status=API.Status.STABLE)
    public static final short DEFAULT_MAXIMUM = Short.MAX_VALUE;

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Short> shortParser() {
        return ShortParser.shortParser((short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Short> shortParser(short minValue) {
        return ParserDescriptor.of(new ShortParser<C>(minValue, Short.MAX_VALUE), Short.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Short> shortParser(short minValue, short maxValue) {
        return ParserDescriptor.of(new ShortParser<C>(minValue, maxValue), Short.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull CommandComponent.Builder<C, Short> shortComponent() {
        return CommandComponent.builder().parser(ShortParser.shortParser());
    }

    public ShortParser(short min, short max) {
        super(Range.shortRange(min, max));
    }

    @Override
    public @NonNull ArgumentParseResult<Short> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        if (!commandInput.isValidShort((ShortRange)this.range())) {
            return ArgumentParseResult.failure(new ShortParseException(commandInput.peekString(), this, commandContext));
        }
        return ArgumentParseResult.success(commandInput.readShort());
    }

    @Override
    public boolean hasMax() {
        return ((ShortRange)this.range()).maxShort() != Short.MAX_VALUE;
    }

    @Override
    public boolean hasMin() {
        return ((ShortRange)this.range()).minShort() != Short.MIN_VALUE;
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return IntegerParser.getSuggestions(this.range(), input);
    }

    @API(status=API.Status.STABLE)
    public static final class ShortParseException
    extends NumberParseException {
        @API(status=API.Status.STABLE)
        public ShortParseException(@NonNull String input, @NonNull ShortParser<?> parser, @NonNull CommandContext<?> commandContext) {
            super(input, parser, commandContext);
        }

        @Override
        public @NonNull String numberType() {
            return "short";
        }
    }
}

