/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.cloud.services;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.NonNull;
import dev.qixils.relocated.cloud.services.AnnotatedMethodService;
import dev.qixils.relocated.cloud.services.annotation.ServiceImplementation;
import dev.qixils.relocated.cloud.services.type.Service;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

enum AnnotatedMethodServiceFactory {
    INSTANCE;


    @NonNull Map<? extends Service<?, ?>, TypeToken<? extends Service<?, ?>>> lookupServices(@NonNull Object instance) throws Exception {
        HashMap map = new HashMap();
        Class<?> clazz = instance.getClass();
        for (Method method : clazz.getDeclaredMethods()) {
            ServiceImplementation serviceImplementation = method.getAnnotation(ServiceImplementation.class);
            if (serviceImplementation == null) continue;
            if (method.getParameterCount() != 1) {
                throw new IllegalArgumentException(String.format("Method '%s' in class '%s' has wrong parameter count. Expected 1, got %d", method.getName(), instance.getClass().getCanonicalName(), method.getParameterCount()));
            }
            map.put(new AnnotatedMethodService(instance, method), TypeToken.get(serviceImplementation.value()));
        }
        return map;
    }
}

