/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.RegionalCommandSync;
import dev.qixils.relocated.annotations.NotNull;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class ExplodeCommand
extends RegionalCommandSync {
    private final String effectName = "explode";

    public ExplodeCommand(PaperCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Explosions were cancelled by another plugin");
    }

    @Override
    protected boolean executeRegionallySync(@NotNull Player player, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        float power = (float)CommandConstants.explosionPower();
        boolean fire = CommandConstants.shouldSpawnFire();
        if (player.getWorld().createExplosion(player.getLocation().subtract(0.0, 0.5, 0.0), power, fire, true)) {
            player.setVelocity(new Vector(0.0, 0.5, 0.0));
            return true;
        }
        return false;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }
}

