/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.packets.SetLanguagePacketS2C;
import dev.qixils.crowdcontrol.common.packets.util.ExtraFeature;
import dev.qixils.crowdcontrol.common.packets.util.LanguageState;
import dev.qixils.crowdcontrol.common.util.SemVer;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.paper.PaperCommand;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.time.Duration;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.bukkit.entity.Player;

public class LanguageCommand
extends PaperCommand
implements CCTimedEffect {
    @NotNull
    private static final Set<UUID> ACTIVE = new HashSet<UUID>();
    @NotNull
    private final String effectName = "language_random";
    @NotNull
    private final Duration defaultDuration = Duration.ofSeconds(30L);
    @NotNull
    private final SemVer minimumModVersion = LanguageState.RANDOM.addedIn();
    @NotNull
    private final Set<ExtraFeature> requiredExtraFeatures = EnumSet.of(ExtraFeature.LANGUAGE_RELOAD);

    public LanguageCommand(@NotNull PaperCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull Player>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            players.removeIf(player -> ACTIVE.contains(player.getUniqueId()));
            if (players.isEmpty()) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "All players already have an active language effect");
            }
            Duration duration = Duration.ofSeconds(request.getEffect().getDurationMillis());
            SetLanguagePacketS2C packet = new SetLanguagePacketS2C(LanguageState.RANDOM, duration);
            for (Player player2 : players) {
                ACTIVE.add(player2.getUniqueId());
                this.plugin.getPluginChannel().sendMessage(player2, packet);
            }
            this.plugin.getScheduledExecutor().schedule(() -> players.forEach(player -> ACTIVE.remove(player.getUniqueId())), duration.toMillis(), TimeUnit.MILLISECONDS);
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, duration.toMillis());
        }));
    }

    @Override
    @NotNull
    public String getEffectName() {
        return this.effectName;
    }

    @NotNull
    public Duration getDefaultDuration() {
        return this.defaultDuration;
    }

    @Override
    @NotNull
    public SemVer getMinimumModVersion() {
        return this.minimumModVersion;
    }

    @Override
    @NotNull
    public Set<ExtraFeature> requiredExtraFeatures() {
        return this.requiredExtraFeatures;
    }
}

