/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.RegionalCommand;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

abstract class NearbyLocationCommand<S>
extends RegionalCommand {
    private final List<String> effectGroups = List.of("walk", "look");

    protected NearbyLocationCommand(PaperCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Nullable
    private static Location highestLocation(@Nullable Location origin) {
        if (origin == null) {
            return null;
        }
        int air = 0;
        World world = origin.getWorld();
        Location location = new Location(world, origin.getX(), (double)(world.getLogicalHeight() - 1), origin.getZ(), origin.getYaw(), origin.getPitch());
        while (true) {
            Block block = location.getBlock();
            if (location.getBlockY() < world.getMinHeight() + 1) {
                return null;
            }
            if (!(block.isBuildable() || block.isLiquid() || block.isSolid())) {
                ++air;
            } else {
                if (air >= 1) break;
                air = 0;
            }
            location.subtract(0.0, 1.0, 0.0);
        }
        return location;
    }

    @Nullable
    private static Location safeLocation(@Nullable Location origin) {
        Location location = NearbyLocationCommand.highestLocation(origin);
        if (location == null) {
            return null;
        }
        Block block = location.getBlock();
        Material type = block.getType();
        if (type == Material.FIRE) {
            block.setType(Material.AIR);
        } else if (!type.isSolid()) {
            block.setType(Material.GLASS);
        }
        location.add(0.5, 1.0, 0.5);
        return location;
    }

    @Nullable
    protected abstract Location search(@NotNull Location var1, @NotNull S var2);

    @NotNull
    protected abstract Collection<S> getSearchTypes(@NotNull World.Environment var1);

    @NotNull
    protected abstract Component nameOf(@NotNull S var1);

    @Nullable
    protected S currentType(@NotNull Location origin) {
        return null;
    }

    @Override
    @Nullable
    protected CCEffectResponse precheck(@NotNull @NotNull List<@NotNull Player> players, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        if (this.isArrayActive(ccPlayer)) {
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Cannot teleport while frozen");
        }
        return null;
    }

    @Override
    @NotNull
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Could not find a location to teleport to");
    }

    @Override
    protected CompletableFuture<Boolean> executeRegionallyAsync(@NotNull Player player, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        World world = player.getWorld();
        Location location = player.getLocation();
        S currentType = this.currentType(location);
        ArrayList<S> searchTypes = new ArrayList<S>(this.getSearchTypes(world.getEnvironment()));
        Collections.shuffle(searchTypes, random);
        CompletionStage<Boolean> success = CompletableFuture.completedFuture(false);
        for (Object searchType : searchTypes) {
            success = success.thenCompose(result -> {
                if (result.booleanValue()) {
                    return CompletableFuture.completedStage(true);
                }
                if (searchType.equals(currentType)) {
                    return CompletableFuture.completedStage(false);
                }
                Location search = this.search(location, searchType);
                if (search == null) {
                    return CompletableFuture.completedStage(false);
                }
                return CompletableFuture.supplyAsync(() -> NearbyLocationCommand.safeLocation(search), runnable -> Bukkit.getRegionScheduler().run((Plugin)this.plugin.getPaperPlugin(), search, $ -> runnable.run())).thenCompose(destination -> {
                    if (destination == null) {
                        return CompletableFuture.completedStage(false);
                    }
                    if (destination.distanceSquared(location) <= 2500.0) {
                        return CompletableFuture.completedStage(false);
                    }
                    if (!world.getWorldBorder().isInside(destination)) {
                        return CompletableFuture.completedStage(false);
                    }
                    return player.teleportAsync(destination).thenApply(tpSuccess -> {
                        if (!tpSuccess.booleanValue()) {
                            return false;
                        }
                        player.sendActionBar((Component)Component.translatable((String)"cc.effect.nearby_location.output", (ComponentLike[])new ComponentLike[]{this.nameOf(searchType).color((TextColor)NamedTextColor.YELLOW)}));
                        return true;
                    });
                });
            });
        }
        return success;
    }

    @Override
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }
}

