/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.RegionalCommandSync;
import dev.qixils.crowdcontrol.plugin.paper.commands.EntityCommand;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.translation.Translatable;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public final class RemoveEntityCommand
extends RegionalCommandSync
implements EntityCommand {
    private final EntityType entityType;
    private final String effectName;
    private final Component displayName;
    private final String image = "remove_entity_creeper";
    private final int price = 250;
    private final byte priority = (byte)-5;
    private final List<String> categories = Collections.singletonList("Remove Entity");

    public RemoveEntityCommand(PaperCrowdControlPlugin plugin, EntityType entityType) {
        super(plugin);
        this.entityType = entityType;
        this.effectName = "remove_entity_" + CommandConstants.csIdOf((Keyed)entityType);
        this.displayName = Component.translatable((String)"cc.effect.remove_entity.name", (ComponentLike[])new ComponentLike[]{Component.translatable((Translatable)entityType)});
    }

    @Override
    public boolean isMonster() {
        if (this.entityType == EntityType.ENDER_DRAGON) {
            return false;
        }
        return EntityCommand.super.isMonster();
    }

    @Override
    @Nullable
    protected CCEffectResponse precheck(@NotNull @NotNull List<@NotNull Player> players, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return this.tryExecute(players, request, ccPlayer);
    }

    @Override
    @NotNull
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No " + this.plugin.getTextUtil().translate((Translatable)this.entityType) + "s found nearby to remove");
    }

    @Override
    protected int getPlayerLimit() {
        return this.plugin.getLimitConfig().getEntityLimit(this.entityType.getKey().getKey());
    }

    @Override
    protected boolean executeRegionallySync(@NotNull Player player, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        if (this.entityType == EntityType.ENDER_DRAGON && player.getWorld().getEnvironment() == World.Environment.THE_END) {
            return false;
        }
        Iterator iterator = player.getLocation().getNearbyEntitiesByType(this.entityType.getEntityClass(), 35.0).iterator();
        if (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            entity.remove();
            return true;
        }
        return false;
    }

    @Override
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    public Component getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public int getPrice() {
        return this.price;
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public List<String> getCategories() {
        return this.categories;
    }
}

