/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.sound.Sounds;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.RegionalCommandSync;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ToastCommand
extends RegionalCommandSync
implements Listener {
    private static final Material[] MATERIALS = new Material[]{Material.BROWN_STAINED_GLASS_PANE, Material.RED_STAINED_GLASS_PANE, Material.ORANGE_STAINED_GLASS_PANE, Material.YELLOW_STAINED_GLASS_PANE, Material.LIME_STAINED_GLASS_PANE, Material.GREEN_STAINED_GLASS_PANE, Material.CYAN_STAINED_GLASS_PANE, Material.LIGHT_BLUE_STAINED_GLASS_PANE, Material.BLUE_STAINED_GLASS_PANE, Material.PURPLE_STAINED_GLASS_PANE, Material.MAGENTA_STAINED_GLASS_PANE, Material.PINK_STAINED_GLASS_PANE, Material.WHITE_STAINED_GLASS_PANE, Material.LIGHT_GRAY_STAINED_GLASS_PANE, Material.GRAY_STAINED_GLASS_PANE, Material.BLACK_STAINED_GLASS_PANE};
    private static final int INVENTORY_SIZE = 27;
    private final Map<UUID, Inventory> openInventories = new HashMap<UUID, Inventory>();
    private final String effectName = "toast";

    public ToastCommand(PaperCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Unable to open window");
    }

    @Override
    protected boolean executeRegionallySync(@NotNull Player player, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        player.playSound(Sounds.ANNOYING.get(new Object[0]), (Sound.Emitter)player);
        Set recipes = player.getDiscoveredRecipes();
        player.undiscoverRecipes((Collection)recipes);
        player.discoverRecipes((Collection)recipes);
        Inventory inv = Bukkit.getServer().createInventory((InventoryHolder)player, 27, CommandConstants.POPUP_TITLE);
        this.openInventories.put(player.getUniqueId(), inv);
        player.openInventory(inv);
        AtomicInteger atomicIndex = new AtomicInteger(random.nextInt(MATERIALS.length));
        CompletableFuture hasStarted = new CompletableFuture();
        Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin.getPaperPlugin(), task -> {
            if (!hasStarted.complete(null) && inv.getViewers().isEmpty()) {
                task.cancel();
                this.openInventories.remove(player.getUniqueId(), inv);
                return;
            }
            int index = atomicIndex.getAndIncrement();
            Material material = MATERIALS[index % MATERIALS.length];
            ItemStack[] contents = new ItemStack[27];
            for (int i = 0; i < 27; ++i) {
                contents[i] = new ItemStack(material);
            }
            inv.setStorageContents(contents);
        }, 1L, 2L);
        return true;
    }

    public void onInventoryEvent(InventoryInteractEvent event) {
        UUID uuid = event.getWhoClicked().getUniqueId();
        Inventory inv = this.openInventories.get(uuid);
        if (inv == null) {
            return;
        }
        if (inv.getViewers().isEmpty()) {
            this.openInventories.remove(uuid);
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClickEvent(InventoryClickEvent event) {
        this.onInventoryEvent((InventoryInteractEvent)event);
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryCreativeEvent(InventoryCreativeEvent event) {
        this.onInventoryEvent((InventoryInteractEvent)event);
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryDragEvent(InventoryDragEvent event) {
        this.onInventoryEvent((InventoryInteractEvent)event);
    }

    public Map<UUID, Inventory> getOpenInventories() {
        return this.openInventories;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }
}

