/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.utils;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.AbstractBlockFinder;
import dev.qixils.crowdcontrol.plugin.paper.utils.MaterialTag;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Predicate;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.Vector;

public class BlockUtil {
    public static final MaterialTag FLOWERS = new MaterialTag(CommandConstants.FLOWERS);
    public static final MaterialTag TORCHES = new MaterialTag(CommandConstants.TORCHES);
    public static final Predicate<Location> SPAWNING_SPACE = location -> location.getBlock().isPassable() && location.clone().add(0.0, 1.0, 0.0).getBlock().isPassable() && location.clone().subtract(0.0, 1.0, 0.0).getBlock().isSolid();

    public static BlockFinder.BlockFinderBuilder blockFinderBuilder() {
        return BlockFinder.builder();
    }

    public static class BlockFinder
    extends AbstractBlockFinder<Location, Vector, World> {
        private BlockFinder(World origin, List<Vector> positions, Predicate<Location> locationValidator) {
            super(origin, positions, locationValidator);
        }

        public static BlockFinderBuilder builder() {
            return new BlockFinderBuilder();
        }

        @Override
        protected Location getLocation(Vector position) {
            return position.toLocation((World)this.origin);
        }

        public static class BlockFinderBuilder
        extends AbstractBlockFinder.AbstractBlockFinderBuilder<BlockFinderBuilder, BlockFinder, Location, Vector, World> {
            @Override
            @NotNull
            public BlockFinderBuilder origin(Location origin) {
                if (origin == null) {
                    return this;
                }
                return (BlockFinderBuilder)((BlockFinderBuilder)this.originPos(origin.toVector())).originWorld(origin.getWorld());
            }

            @Override
            protected int getFloorX(@NotNull Vector pos) {
                return pos.getBlockX();
            }

            @Override
            protected int getFloorY(@NotNull Vector pos) {
                return pos.getBlockY();
            }

            @Override
            protected int getFloorZ(@NotNull Vector pos) {
                return pos.getBlockZ();
            }

            @Override
            @NotNull
            protected Vector createVector(int x, int y, int z) {
                return new Vector(x, y, z);
            }

            public BlockFinder build() {
                List<Vector> positions = this.preBuildDataInit();
                return new BlockFinder((World)this.originWorld, positions, this.locationValidator);
            }
        }
    }
}

