/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.util;

import dev.qixils.crowdcontrol.common.util.Weighted;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import dev.qixils.relocated.annotations.UnknownNullability;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class RandomUtil {
    @NotNull
    public static final Random RNG = new Random();

    public static <T> @UnknownNullability T randomElementFrom(@NotNull Collection<@Nullable T> from) throws IllegalArgumentException {
        if (from instanceof List) {
            return RandomUtil.randomElementFrom((List)from);
        }
        if (from.isEmpty()) {
            throw new IllegalArgumentException("Collection may not be empty");
        }
        int index = RNG.nextInt(from.size());
        int iteration = 0;
        for (T object : from) {
            if (iteration++ != index) continue;
            return object;
        }
        throw new IllegalStateException("Could not find a random object. Was the collection updated?");
    }

    public static <T> @UnknownNullability T randomElementFrom(@NotNull List<@Nullable T> from) throws IllegalArgumentException {
        if (from.isEmpty()) {
            throw new IllegalArgumentException("List may not be empty");
        }
        return from.get(RNG.nextInt(from.size()));
    }

    public static <T> @UnknownNullability T randomElementFrom(T @NotNull [] from) throws IllegalArgumentException {
        if (from.length == 0) {
            throw new IllegalArgumentException("Array may not be empty");
        }
        return from[RNG.nextInt(from.length)];
    }

    @Deprecated
    @NotNull
    public static <T extends Enum<T>> T randomElementFrom(@NotNull Class<T> from) {
        Enum[] constants = (Enum[])from.getEnumConstants();
        if (constants == null) {
            try {
                constants = (Enum[])Arrays.stream(from.getMethods()).filter(method -> "values".equals(method.getName()) && method.getReturnType().isArray() && Modifier.isStatic(method.getModifiers())).findAny().orElseThrow(() -> new IllegalArgumentException("Class is not an enum")).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Class is not an enum");
            }
        }
        return (T)RandomUtil.randomElementFrom(constants);
    }

    public static <T> @UnknownNullability T randomElementFrom(@NotNull Iterator<@Nullable T> from) throws IllegalArgumentException {
        ArrayList<T> list = new ArrayList<T>();
        while (from.hasNext()) {
            list.add(from.next());
        }
        return (T)RandomUtil.randomElementFrom(list);
    }

    public static <T> @UnknownNullability T randomElementFrom(@NotNull Iterable<@Nullable T> from) throws IllegalArgumentException {
        return RandomUtil.randomElementFrom(from.iterator());
    }

    public static <T> @UnknownNullability T randomElementFrom(@NotNull Stream<@Nullable T> from) throws IllegalArgumentException {
        return RandomUtil.randomElementFrom(from.iterator());
    }

    @NotNull
    public static <T> @NotNull Optional<@NotNull T> randomElementFrom(@NotNull Iterator<@Nullable T> from, @NotNull @NotNull Predicate<@NotNull T> validator) {
        ArrayList<T> items = new ArrayList<T>();
        while (from.hasNext()) {
            T item = from.next();
            if (item == null || !validator.test(item)) continue;
            items.add(item);
        }
        if (items.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(RandomUtil.randomElementFrom(items));
    }

    @NotNull
    public static <T> @NotNull Optional<@NotNull T> randomElementFrom(@NotNull Iterable<@Nullable T> from, @NotNull @NotNull Predicate<@NotNull T> validator) {
        return RandomUtil.randomElementFrom(from.iterator(), validator);
    }

    @NotNull
    public static <T> @NotNull Optional<@NotNull T> randomElementFrom(@NotNull Collection<@Nullable T> from, @NotNull @NotNull Predicate<@NotNull T> validator) {
        ArrayList<T> items = new ArrayList<T>(from);
        items.removeIf(item -> item == null || !validator.test(item));
        if (items.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(RandomUtil.randomElementFrom(items));
    }

    @NotNull
    public static <T> @NotNull Optional<@NotNull T> randomElementFrom(@NotNull Stream<@Nullable T> from, @NotNull @NotNull Predicate<@NotNull T> validator) {
        return RandomUtil.randomElementFrom(from.iterator(), validator);
    }

    @NotNull
    public static <T> @NotNull Optional<@NotNull T> randomElementFrom(T @NotNull [] from, @NotNull @NotNull Predicate<@NotNull T> validator) {
        ArrayList<T> items = new ArrayList<T>();
        for (T item : from) {
            if (item == null || !validator.test(item)) continue;
            items.add(item);
        }
        if (items.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(RandomUtil.randomElementFrom(items));
    }

    @NotNull
    public static <T extends Weighted> T weightedRandom(@NotNull @NotNull T @NotNull [] weightedArray, int totalWeights) throws IllegalArgumentException, NullPointerException {
        int idx;
        if (weightedArray.length == 0) {
            throw new IllegalArgumentException("Array may not be empty");
        }
        double r = Math.random() * (double)totalWeights;
        for (idx = 0; idx < weightedArray.length - 1 && !((r -= (double)weightedArray[idx].getWeight()) <= 0.0); ++idx) {
        }
        return weightedArray[idx];
    }

    @NotNull
    public static <T extends Weighted> T weightedRandom(@NotNull @NotNull T @NotNull [] weightedArray) throws IllegalArgumentException, NullPointerException {
        if (weightedArray.length == 0) {
            throw new IllegalArgumentException("Array may not be empty");
        }
        int total = 0;
        for (T t : weightedArray) {
            total += t.getWeight();
        }
        return (T)RandomUtil.weightedRandom(weightedArray, (int)total);
    }

    @NotNull
    public static <T extends Weighted> T weightedRandom(@NotNull @NotNull List<@NotNull T> weightedList, int totalWeights) throws IllegalArgumentException, NullPointerException {
        int idx;
        if (weightedList.isEmpty()) {
            throw new IllegalArgumentException("List may not be empty");
        }
        double r = Math.random() * (double)totalWeights;
        for (idx = 0; idx < weightedList.size() - 1 && !((r -= (double)((Weighted)weightedList.get(idx)).getWeight()) <= 0.0); ++idx) {
        }
        return (T)((Weighted)weightedList.get(idx));
    }

    @NotNull
    public static <T extends Weighted> T weightedRandom(@NotNull @NotNull List<@NotNull T> weightedList) throws IllegalArgumentException, NullPointerException {
        if (weightedList.isEmpty()) {
            throw new IllegalArgumentException("List may not be empty");
        }
        int total = 0;
        for (Weighted t : weightedList) {
            total += t.getWeight();
        }
        return RandomUtil.weightedRandom(weightedList, total);
    }

    @NotNull
    public static <T> T weightedRandom(@NotNull @NotNull Map<@NotNull T, @NotNull Integer> weightedMap, int totalWeights) throws IllegalArgumentException, NullPointerException {
        int idx;
        if (weightedMap.isEmpty()) {
            throw new IllegalArgumentException("Map may not be empty");
        }
        ArrayList<Map.Entry<T, Integer>> entries = new ArrayList<Map.Entry<T, Integer>>(weightedMap.entrySet());
        double r = Math.random() * (double)totalWeights;
        for (idx = 0; idx < entries.size() - 1 && !((r -= (double)((Integer)((Map.Entry)entries.get(idx)).getValue()).intValue()) <= 0.0); ++idx) {
        }
        return (T)((Map.Entry)entries.get(idx)).getKey();
    }

    @NotNull
    public static <T> T weightedRandom(@NotNull @NotNull Map<@NotNull T, @NotNull Integer> weightedMap) throws IllegalArgumentException, NullPointerException {
        if (weightedMap.isEmpty()) {
            throw new IllegalArgumentException("Map may not be empty");
        }
        int total = 0;
        for (int i : weightedMap.values()) {
            total += i;
        }
        return RandomUtil.weightedRandom(weightedMap, total);
    }

    public static int nextInclusiveInt(int from, int to) {
        return from + RNG.nextInt(to - from + 1);
    }

    @Deprecated
    public static double nextDouble(double from, double to) {
        return RNG.nextDouble(from, to);
    }
}

