/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper;

import dev.qixils.crowdcontrol.common.LoginData;
import dev.qixils.crowdcontrol.common.PlayerEntityMapper;
import dev.qixils.crowdcontrol.plugin.paper.CommandSenderMapper;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

class PlayerMapper
extends CommandSenderMapper<Player>
implements PlayerEntityMapper<Player> {
    public PlayerMapper(PaperCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    public Optional<UUID> tryGetUniqueId(@NotNull Player entity) {
        return Optional.of(entity.getUniqueId());
    }

    @Override
    @NotNull
    public UUID getUniqueId(@NotNull Player entity) {
        return entity.getUniqueId();
    }

    @Override
    @NotNull
    public String getUsername(@NotNull Player player) {
        return player.getName();
    }

    @Override
    @NotNull
    public Optional<Player> getPlayer(@NotNull UUID uuid) {
        return Optional.ofNullable(Bukkit.getServer().getPlayer(uuid));
    }

    @Override
    @NotNull
    public Optional<Locale> getLocale(@NotNull Player entity) {
        return Optional.of(entity.locale());
    }

    @Override
    @NotNull
    public Optional<Player> getPlayer(@NotNull InetAddress ip) {
        Player result = null;
        for (Player player : Bukkit.getOnlinePlayers()) {
            InetSocketAddress address = player.getAddress();
            if (address == null || !Objects.equals(address.getAddress(), ip)) continue;
            if (result != null) {
                return Optional.empty();
            }
            result = player;
        }
        return Optional.ofNullable(result);
    }

    @Override
    @NotNull
    public Optional<Player> getPlayerByLogin(@NotNull LoginData login) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getName().equalsIgnoreCase(login.getName()) && !player.getUniqueId().equals(login.getId())) continue;
            return Optional.of(player);
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    public Optional<InetAddress> getIP(@NotNull Player player) {
        return Optional.ofNullable(player.getAddress()).map(InetSocketAddress::getAddress);
    }
}

