/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper;

import dev.qixils.crowdcontrol.common.packets.PluginPacket;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.relocated.annotations.ApiStatus;
import dev.qixils.relocated.annotations.NotNull;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class PluginChannel
implements PluginMessageListener {
    private final PaperCrowdControlPlugin plugin;
    private final Map<String, BiConsumer<Player, byte[]>> incomingMessageHandlers = new HashMap<String, BiConsumer<Player, byte[]>>();

    public <T extends PluginPacket> void registerIncomingPluginChannel(PluginPacket.Metadata<T> type, BiConsumer<Player, T> handler) {
        this.incomingMessageHandlers.put(type.channel(), (player, bytes) -> handler.accept((Player)player, (Object)((PluginPacket)type.factory().apply(Unpooled.wrappedBuffer((byte[])bytes)))));
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this.plugin.getPaperPlugin(), type.channel(), (PluginMessageListener)this);
    }

    public void registerOutgoingPluginChannel(PluginPacket.Metadata<?> type) {
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin.getPaperPlugin(), type.channel());
    }

    @ApiStatus.Internal
    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, byte @NotNull [] message) {
        this.plugin.getSLF4JLogger().debug("Received message {} from {}: {}", new Object[]{channel, player.getUniqueId(), new String(message, StandardCharsets.UTF_8)});
        BiConsumer<Player, byte[]> handler = this.incomingMessageHandlers.get(channel);
        if (handler == null) {
            return;
        }
        handler.accept(player, message);
    }

    public void sendMessage(Player player, PluginPacket packet) {
        ByteBuf buf = Unpooled.buffer();
        packet.write(buf);
        player.sendPluginMessage((Plugin)this.plugin.getPaperPlugin(), packet.metadata().channel(), buf.copy().array());
    }

    public PluginChannel(PaperCrowdControlPlugin plugin) {
        this.plugin = plugin;
    }
}

