/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.RegionalCommandSync;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class DeleteRandomItemCommand
extends RegionalCommandSync {
    private final String effectName = "delete_random_item";

    public DeleteRandomItemCommand(PaperCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No players have items");
    }

    @Override
    protected boolean executeRegionallySync(@NotNull Player player, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        PlayerInventory inv = player.getInventory();
        List indices = IntStream.range(0, inv.getSize()).boxed().collect(Collectors.toList());
        Collections.shuffle(indices);
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            ItemStack stack = inv.getItem(i);
            if (stack == null || stack.getType().isAir() || stack.getAmount() == 0) continue;
            inv.setItem(i, null);
            return true;
        }
        return false;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }
}

