/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.RegionalCommandSync;
import dev.qixils.relocated.annotations.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.BiFunction;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemDamageCommand
extends RegionalCommandSync {
    private final BiFunction<Integer, Material, Integer> handleItem;
    private final String effectName;
    private final EquipmentSlot[] slots = new EquipmentSlot[]{EquipmentSlot.HAND, EquipmentSlot.OFF_HAND, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET, EquipmentSlot.HEAD};

    public ItemDamageCommand(PaperCrowdControlPlugin plugin, boolean repair) {
        super(plugin);
        this.handleItem = repair ? (damage, type) -> 0 : (damage, type) -> damage + type.getMaxDurability() / 4;
        this.effectName = (repair ? "repair" : "damage") + "_item";
    }

    @Override
    @NotNull
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Player(s) not holding a damaged item");
    }

    @Override
    protected boolean executeRegionallySync(@NotNull Player player, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ArrayList<EquipmentSlot> slots = new ArrayList<EquipmentSlot>(Arrays.asList(this.slots));
        Collections.shuffle(slots);
        PlayerInventory inv = player.getInventory();
        for (EquipmentSlot slot : slots) {
            int newDamage;
            ItemMeta meta;
            ItemStack item = inv.getItem(slot);
            if (item.getType().isEmpty() || item.getAmount() < 1 || item.getType().getMaxDurability() <= 1 || (meta = item.getItemMeta()).isUnbreakable() || !(meta instanceof Damageable)) continue;
            Damageable damageable = (Damageable)meta;
            Material type = item.getType();
            int curDamage = damageable.getDamage();
            if (!CommandConstants.canApplyDamage(curDamage, newDamage = this.handleItem.apply(damageable.getDamage(), type).intValue(), type.getMaxDurability())) continue;
            damageable.setDamage(newDamage);
            item.setItemMeta((ItemMeta)damageable);
            return true;
        }
        return false;
    }

    public BiFunction<Integer, Material, Integer> getHandleItem() {
        return this.handleItem;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    public EquipmentSlot[] getSlots() {
        return this.slots;
    }
}

