/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.util.TextUtil;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.commands.NearbyLocationCommand;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.StructureType;
import org.bukkit.World;

public class StructureCommand
extends NearbyLocationCommand<StructureType> {
    private static final Map<World.Environment, List<StructureType>> STRUCTURES;
    private static final Map<World.Environment, List<String>> KEYED_STRUCTURES;
    private final String effectName = "structure";

    public StructureCommand(PaperCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    @Nullable
    protected Location search(@NotNull Location origin, @NotNull StructureType searchType) {
        return origin.getWorld().locateNearestStructure(origin, searchType, 64, false);
    }

    @Override
    @NotNull
    protected Collection<StructureType> getSearchTypes(@NotNull World.Environment environment) {
        return STRUCTURES.get(environment);
    }

    @Override
    @NotNull
    protected Component nameOf(@NotNull StructureType searchType) {
        return Component.text((String)TextUtil.titleCase(searchType.getName()));
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    static {
        KEYED_STRUCTURES = Map.of(World.Environment.NORMAL, List.of("mineshaft", "village", "stronghold", "jungle_pyramid", "ocean_ruin", "desert_pyramid", "igloo", "swamp_hut", "monument", "mansion", "buried_treasure", "shipwreck", "pillager_outpost", "ruined_portal"), World.Environment.NETHER, List.of("fortress", "ruined_portal", "bastion_remnant"), World.Environment.THE_END, List.of("endcity"), World.Environment.CUSTOM, StructureType.getStructureTypes().values().stream().map(StructureType::getName).toList());
        HashMap<World.Environment, List<StructureType>> biomeMap = new HashMap<World.Environment, List<StructureType>>(KEYED_STRUCTURES.size());
        for (Map.Entry<World.Environment, List<String>> entry : KEYED_STRUCTURES.entrySet()) {
            List<String> keyedBiomes = entry.getValue();
            ArrayList<StructureType> biomes = new ArrayList<StructureType>(keyedBiomes.size());
            Map structures = StructureType.getStructureTypes();
            for (String biome : keyedBiomes) {
                StructureType structure = (StructureType)structures.get(biome);
                if (structure == null) continue;
                biomes.add(structure);
            }
            biomeMap.put(entry.getKey(), biomes);
        }
        STRUCTURES = biomeMap;
    }
}

