/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands.executeorperish;

import dev.qixils.relocated.annotations.NotNull;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class ConditionFlags
implements Predicate<Player> {
    @NotNull
    public static final ConditionFlags DEFAULT = ConditionFlags.builder().build();
    @NotNull
    public static final ConditionFlags OVERWORLD = ConditionFlags.builder().allowedDimensions(Collections.singletonList(World.Environment.NORMAL)).build();
    @NotNull
    public static final ConditionFlags NETHER = ConditionFlags.builder().allowedDimensions(Collections.singletonList(World.Environment.NETHER)).build();
    @NotNull
    public static final ConditionFlags THE_END = ConditionFlags.builder().allowedDimensions(Collections.singletonList(World.Environment.THE_END)).build();
    @NotNull
    private final List<World.Environment> allowedDimensions;
    @NotNull
    private final Map<Material, Integer> requiredItems;

    @Override
    public boolean test(@NotNull Player player) {
        if (!this.allowedDimensions.isEmpty() && !this.allowedDimensions.contains(player.getWorld().getEnvironment())) {
            return false;
        }
        for (Map.Entry<Material, Integer> entry : this.requiredItems.entrySet()) {
            Material item = entry.getKey();
            int required = entry.getValue();
            int count = 0;
            for (ItemStack stack : player.getInventory().getContents()) {
                if (stack != null && stack.getType() == item && (count += stack.getAmount()) >= required) break;
            }
            if (count >= required) continue;
            return false;
        }
        return true;
    }

    private static List<World.Environment> $default$allowedDimensions() {
        return Collections.emptyList();
    }

    private static Map<Material, Integer> $default$requiredItems() {
        return Collections.emptyMap();
    }

    ConditionFlags(@NotNull List<World.Environment> allowedDimensions, @NotNull Map<Material, Integer> requiredItems) {
        if (allowedDimensions == null) {
            throw new NullPointerException("allowedDimensions is marked non-null but is null");
        }
        if (requiredItems == null) {
            throw new NullPointerException("requiredItems is marked non-null but is null");
        }
        this.allowedDimensions = allowedDimensions;
        this.requiredItems = requiredItems;
    }

    public static ConditionFlagsBuilder builder() {
        return new ConditionFlagsBuilder();
    }

    @NotNull
    public List<World.Environment> getAllowedDimensions() {
        return this.allowedDimensions;
    }

    @NotNull
    public Map<Material, Integer> getRequiredItems() {
        return this.requiredItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConditionFlags)) {
            return false;
        }
        ConditionFlags other = (ConditionFlags)o;
        List<World.Environment> this$allowedDimensions = this.getAllowedDimensions();
        List<World.Environment> other$allowedDimensions = other.getAllowedDimensions();
        if (this$allowedDimensions == null ? other$allowedDimensions != null : !((Object)this$allowedDimensions).equals(other$allowedDimensions)) {
            return false;
        }
        Map<Material, Integer> this$requiredItems = this.getRequiredItems();
        Map<Material, Integer> other$requiredItems = other.getRequiredItems();
        return !(this$requiredItems == null ? other$requiredItems != null : !((Object)this$requiredItems).equals(other$requiredItems));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<World.Environment> $allowedDimensions = this.getAllowedDimensions();
        result = result * 59 + ($allowedDimensions == null ? 43 : ((Object)$allowedDimensions).hashCode());
        Map<Material, Integer> $requiredItems = this.getRequiredItems();
        result = result * 59 + ($requiredItems == null ? 43 : ((Object)$requiredItems).hashCode());
        return result;
    }

    public String toString() {
        return "ConditionFlags(allowedDimensions=" + String.valueOf(this.getAllowedDimensions()) + ", requiredItems=" + String.valueOf(this.getRequiredItems()) + ")";
    }

    public static class ConditionFlagsBuilder {
        private boolean allowedDimensions$set;
        private List<World.Environment> allowedDimensions$value;
        private boolean requiredItems$set;
        private Map<Material, Integer> requiredItems$value;

        ConditionFlagsBuilder() {
        }

        public ConditionFlagsBuilder allowedDimensions(@NotNull List<World.Environment> allowedDimensions) {
            if (allowedDimensions == null) {
                throw new NullPointerException("allowedDimensions is marked non-null but is null");
            }
            this.allowedDimensions$value = allowedDimensions;
            this.allowedDimensions$set = true;
            return this;
        }

        public ConditionFlagsBuilder requiredItems(@NotNull Map<Material, Integer> requiredItems) {
            if (requiredItems == null) {
                throw new NullPointerException("requiredItems is marked non-null but is null");
            }
            this.requiredItems$value = requiredItems;
            this.requiredItems$set = true;
            return this;
        }

        public ConditionFlags build() {
            List<World.Environment> allowedDimensions$value = this.allowedDimensions$value;
            if (!this.allowedDimensions$set) {
                allowedDimensions$value = ConditionFlags.$default$allowedDimensions();
            }
            Map<Material, Integer> requiredItems$value = this.requiredItems$value;
            if (!this.requiredItems$set) {
                requiredItems$value = ConditionFlags.$default$requiredItems();
            }
            return new ConditionFlags(allowedDimensions$value, requiredItems$value);
        }

        public String toString() {
            return "ConditionFlags.ConditionFlagsBuilder(allowedDimensions$value=" + String.valueOf(this.allowedDimensions$value) + ", requiredItems$value=" + String.valueOf(this.requiredItems$value) + ")";
        }
    }
}

