/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.mc;

import dev.qixils.crowdcontrol.common.mc.CCLivingEntity;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.mc.PaperEntity;
import dev.qixils.crowdcontrol.plugin.paper.utils.AttributeUtil;
import dev.qixils.relocated.annotations.NotNull;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class PaperLivingEntity
extends PaperEntity
implements CCLivingEntity {
    public PaperLivingEntity(@NotNull PaperCrowdControlPlugin plugin, @NotNull LivingEntity entity) {
        super(plugin, (Entity)entity);
    }

    @NotNull
    public LivingEntity entity() {
        return (LivingEntity)super.entity();
    }

    @Override
    public double health() {
        return this.entity().getHealth();
    }

    @Override
    public void health(double health) {
        this.execute(() -> this.entity().setHealth(health));
    }

    @Override
    public double maxHealth() {
        AttributeInstance attribute = this.entity().getAttribute(Attribute.MAX_HEALTH);
        if (attribute == null) {
            return 20.0;
        }
        return attribute.getValue();
    }

    @Override
    public double maxHealthOffset() {
        AttributeInstance attribute = this.entity().getAttribute(Attribute.MAX_HEALTH);
        if (attribute == null) {
            return 0.0;
        }
        AttributeModifier modifier = null;
        for (AttributeModifier attributeModifier : attribute.getModifiers()) {
            if (!attributeModifier.getName().equals("max-health-cc") && !attributeModifier.getName().equals(MAX_HEALTH_MODIFIER_UUID.toString())) continue;
            modifier = attributeModifier;
            break;
        }
        return modifier == null ? 0.0 : modifier.getAmount();
    }

    @Override
    public void maxHealthOffset(double newOffset) {
        this.execute(() -> {
            AttributeUtil.addModifier((Attributable)this.entity(), Attribute.MAX_HEALTH, MAX_HEALTH_MODIFIER_UUID, "max-health-cc", newOffset, AttributeModifier.Operation.ADD_NUMBER, true);
            float computedMaxHealth = (float)(20.0 + newOffset);
            this.health(Math.min(this.health(), (double)computedMaxHealth));
        });
    }

    @Override
    public void damage(double damage) {
        this.execute(() -> this.entity().damage(damage));
    }

    @Override
    public void heal(double amount) {
        this.execute(() -> this.health(this.health() + amount));
    }

    @Override
    public void kill() {
        this.execute(() -> this.health(0.0));
    }
}

