/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.cloud.brigadier.permission;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.NonNull;
import dev.qixils.relocated.cloud.SenderMapper;
import dev.qixils.relocated.cloud.brigadier.permission.BrigadierPermissionChecker;
import dev.qixils.relocated.cloud.internal.CommandNode;
import dev.qixils.relocated.cloud.permission.Permission;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="2.0.0")
public final class BrigadierPermissionPredicate<C, S>
implements Predicate<S> {
    private final SenderMapper<S, C> senderMapper;
    private final BrigadierPermissionChecker<C> permissionChecker;
    private final CommandNode<?> node;

    public BrigadierPermissionPredicate(@NonNull SenderMapper<S, C> senderMapper, @NonNull BrigadierPermissionChecker<C> permissionChecker, @NonNull CommandNode<?> node) {
        this.senderMapper = senderMapper;
        this.permissionChecker = permissionChecker;
        this.node = node;
    }

    @Override
    public boolean test(@NonNull S source) {
        C cloudSender = this.senderMapper.map(source);
        Map accessMap = this.node.nodeMeta().getOrDefault(CommandNode.META_KEY_ACCESS, Collections.emptyMap());
        for (Map.Entry entry : accessMap.entrySet()) {
            if (!GenericTypeReflector.isSuperType((Type)entry.getKey(), cloudSender.getClass()) || !this.permissionChecker.hasPermission(cloudSender, (Permission)entry.getValue())) continue;
            return true;
        }
        return false;
    }
}

