/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.cloud.permission;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.NonNull;
import dev.qixils.relocated.cloud.key.CloudKey;
import dev.qixils.relocated.cloud.permission.PermissionResult;
import dev.qixils.relocated.cloud.permission.PredicatePermission;
import java.util.function.Predicate;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, consumers={"dev.qixils.relocated.cloud.*"})
final class WrappingPredicatePermission<C>
implements PredicatePermission<C> {
    private final CloudKey<Void> key;
    private final Predicate<C> predicate;

    WrappingPredicatePermission(@NonNull CloudKey<Void> key, @NonNull Predicate<C> predicate) {
        this.key = key;
        this.predicate = predicate;
    }

    @Override
    public @NonNull PermissionResult testPermission(@NonNull C sender) {
        return PermissionResult.of(this.predicate.test(sender), this);
    }

    @Override
    public @NonNull CloudKey<Void> key() {
        return this.key;
    }

    public String toString() {
        return this.key.name();
    }
}

